/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.transactionprovider;

import java.sql.Connection;
import java.sql.SQLException;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.transactionprovider.ClosableTransaction;
import org.clazzes.util.sql.transactionprovider.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosableTransactionImpl
implements ClosableTransaction {
    private static final Logger log = LoggerFactory.getLogger(ClosableTransactionImpl.class);
    private Boolean willCommit = null;
    private boolean wasAlreadyClosed = false;
    private final String threadLocalKey;
    private final int previousIsolationLevel;
    private final boolean previousAutoCommit;

    public ClosableTransactionImpl(String threadLocalKey, int previousIsolationLevel, boolean autoCommit) {
        this.threadLocalKey = threadLocalKey;
        this.previousIsolationLevel = previousIsolationLevel;
        this.previousAutoCommit = autoCommit;
    }

    @Override
    public void willCommit() {
        this.willCommit = true;
    }

    @Override
    public void willRollback() {
        this.willCommit = false;
    }

    @Override
    public void close() throws TransactionException {
        if (this.wasAlreadyClosed) {
            log.warn("Transaction AutoClosable {} called close() twice - likely an error! ThreadLocalKey={}", this.getClass(), (Object)this.threadLocalKey);
            return;
        }
        this.wasAlreadyClosed = true;
        Connection connection = (Connection)ThreadLocalManager.unbindResource((String)this.threadLocalKey);
        if (connection == null) {
            throw new TransactionException("Lost connection object - someone removed " + this.threadLocalKey);
        }
        try {
            if (this.willCommit == null) {
                log.debug("Rolling back, because neither willCommit() nor willRollback() was called (Exception).");
                this.doRollback(connection);
            } else if (this.willCommit.booleanValue()) {
                if (log.isTraceEnabled()) {
                    log.trace("Committing transaction.");
                }
                this.doCommit(connection);
            } else {
                log.debug("Rolling back, because willRollback() was called.");
                this.doRollback(connection);
            }
        }
        finally {
            this.doClose(connection);
        }
    }

    private void doRollback(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException e) {
            throw new TransactionException("Error while rolling back transaction", e);
        }
    }

    private void doCommit(Connection connection) {
        try {
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e2) {
                TransactionException transactionException = new TransactionException("Error while rolling back transaction after failed commit", e2);
                transactionException.addSuppressed(e);
                throw transactionException;
            }
            throw new TransactionException("Error while committing transaction.", e);
        }
    }

    private void doClose(Connection connection) {
        try {
            connection.setTransactionIsolation(this.previousIsolationLevel);
            connection.setAutoCommit(this.previousAutoCommit);
            connection.close();
        }
        catch (SQLException e) {
            log.warn("Error while closing connection.", (Throwable)e);
        }
    }
}

