/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import java.sql.Statement;
import javax.sql.DataSource;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.SQLDialectFactory;
import org.clazzes.util.sql.dao.HiLoIdGenerator;
import org.clazzes.util.sql.dao.IdGenerator;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.clazzes.util.sql.helper.JDBCTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHiLoIdGenerator
implements IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(HiLoIdGenerator.class);
    public static final String DEFAULT_ID_TABLE_NAME = "ID_GENERATOR";
    public static final String DEFAULT_NEXT_ID_COL_NAME = "NEXT_ID";
    private String idTableName = "ID_GENERATOR";
    private String nextIdColumnName = "NEXT_ID";
    private String loIdColumnName;
    private long blockSize = 100L;
    private DataSource dataSource;
    private String threadLocalKey;
    private State state = new State(null, 0L);

    protected abstract Long getInitialHiValue();

    protected abstract Long getHiStepSize();

    protected abstract Long getBaseId();

    private boolean isRetryable(Throwable e) {
        SQLException sqlE;
        if (e == null) {
            return false;
        }
        if (e instanceof SQLException && ("40001".equals((sqlE = (SQLException)e).getSQLState()) || sqlE.getErrorCode() == 8177)) {
            return true;
        }
        return this.isRetryable(e.getCause());
    }

    public boolean supportSelectForUpdate(Connection conn) throws SQLException {
        switch (SQLDialectFactory.getSQLDialect(conn)) {
            case DERBY: 
            case POSTGRES: 
            case MYSQL: 
            case ORACLE: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withTransaction(TransactionFn fn) throws SQLException {
        boolean useSavepoint;
        Connection existingConnection = this.threadLocalKey != null ? (Connection)ThreadLocalManager.getBoundResource((String)this.threadLocalKey) : null;
        boolean bl = useSavepoint = existingConnection != null && (existingConnection.getTransactionIsolation() == 8 || this.supportSelectForUpdate(existingConnection));
        if (useSavepoint) {
            Savepoint savepoint = existingConnection.setSavepoint();
            boolean successful = false;
            State newState = this.state.copy();
            try {
                try (Statement statement = existingConnection.createStatement();){
                    this.lockRows(statement);
                    fn.accept(newState, statement);
                }
                successful = true;
            }
            finally {
                if (successful) {
                    try {
                        existingConnection.releaseSavepoint(savepoint);
                    }
                    catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {}
                } else {
                    existingConnection.rollback(savepoint);
                }
            }
            this.state = newState;
        } else {
            State newState;
            while (true) {
                newState = this.state.copy();
                try (JDBCTransaction txn = this.openSerializableTransaction();
                     Statement statement = txn.getConnection().createStatement();){
                    fn.accept(newState, statement);
                    txn.commit();
                }
                catch (Exception e) {
                    if (this.isRetryable(e)) continue;
                    throw e;
                }
                break;
            }
            this.state = newState;
        }
    }

    protected JDBCTransaction openSerializableTransaction() throws SQLException {
        return new JDBCTransaction(this.dataSource, 8);
    }

    private void lockRows(Statement statement) throws SQLException {
        if (statement.getConnection().getTransactionIsolation() == 8) {
            return;
        }
        assert (this.supportSelectForUpdate(statement.getConnection()));
        statement.executeQuery("select * from " + this.idTableName + " for update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchNextId(State state, Statement statement) throws SQLException {
        Long nextId = null;
        try (ResultSet rs = statement.executeQuery("select " + this.nextIdColumnName + " from " + this.idTableName);){
            while (rs.next()) {
                if (nextId == null) {
                    nextId = JDBCHelper.getLong(rs, 1);
                    continue;
                }
                throw new DAOException("Id table [" + this.idTableName + "] contains multiple rows.");
            }
        }
        state.hiValue = nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchInitialHiLoId(State state, Statement statement) throws SQLException {
        Long nextId = null;
        try (ResultSet rs = statement.executeQuery("select " + this.nextIdColumnName + "," + this.loIdColumnName + " from " + this.idTableName);){
            while (rs.next()) {
                if (nextId == null) {
                    nextId = JDBCHelper.getLong(rs, 1);
                    state.loValue = rs.getLong(2);
                    continue;
                }
                throw new DAOException("Id table [" + this.idTableName + "] contains multiple rows.");
            }
        }
        if (state.loValue <= -this.blockSize || state.loValue > 0L) {
            log.warn("Table [{}] contains invalid lo value [{}], ignoring this value and starting a new block.", (Object)this.idTableName, (Object)state.loValue);
            state.loValue = 0L;
        } else if (state.loValue != 0L) {
            log.warn("Table [{}] contains valid lo value [{}], resetting table lo value to zero.", (Object)this.idTableName, (Object)state.loValue);
            statement.executeUpdate("update " + this.idTableName + " set " + this.loIdColumnName + " = 0");
        }
        state.hiValue = nextId;
    }

    protected void incrementHiValue(Statement statement) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("update ");
        sb.append(this.idTableName);
        sb.append(" set ");
        sb.append(this.nextIdColumnName);
        sb.append("=");
        sb.append(this.nextIdColumnName);
        sb.append("+");
        sb.append(this.getHiStepSize());
        if (this.loIdColumnName != null) {
            sb.append(", ");
            sb.append(this.loIdColumnName);
            sb.append("=0");
        }
        statement.executeUpdate(sb.toString());
    }

    public void initialize() throws SQLException {
        this.withTransaction((state, statement) -> {
            if (this.loIdColumnName == null) {
                this.fetchNextId(state, statement);
                state.loValue = 0L;
            } else {
                this.fetchInitialHiLoId(state, statement);
            }
            if (state.hiValue == null) {
                state.hiValue = this.getInitialHiValue();
                state.loValue = this.loIdColumnName == null ? 0L : 1L - this.blockSize;
                log.info("Id table [{}] contains no rows, inserting initial value [{}].", (Object)this.idTableName, (Object)state.hiValue);
                StringBuffer sb = new StringBuffer();
                sb.append("insert into ");
                sb.append(this.idTableName);
                sb.append(" (");
                sb.append(this.nextIdColumnName);
                if (this.loIdColumnName != null) {
                    sb.append(",");
                    sb.append(this.loIdColumnName);
                }
                sb.append(") values (");
                sb.append(state.hiValue);
                if (this.loIdColumnName != null) {
                    sb.append(",");
                    sb.append(state.loValue);
                }
                sb.append(")");
                statement.executeUpdate(sb.toString());
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Last known high value was [{}].", (Object)this.state.hiValue);
        }
    }

    public void destroy() throws SQLException {
        if (this.loIdColumnName == null) {
            log.info("No low table column set, HiLo ID Generator destroy() method will do nothing.");
            return;
        }
        if (this.state.hiValue == null || this.state.loValue >= 0L) {
            log.info("ID Generator did not generate an incomplete hi block, stopping ID generator now.");
        } else {
            this.withTransaction((state, statement) -> {
                int n = statement.executeUpdate("update " + this.idTableName + " set " + this.loIdColumnName + "=" + state.loValue + " where " + this.nextIdColumnName + "=" + state.hiValue);
                if (n == 0) {
                    log.info("ID Generator generated an incomplete hi block for [hi={},lo={}], but another instance has taken yet-another hi block.", (Object)state.hiValue, (Object)state.loValue);
                } else {
                    log.info("ID Generator generated an incomplete hi block for [hi={},lo={}], persisting lo value for future use.", (Object)state.hiValue, (Object)state.loValue);
                }
            });
        }
    }

    @Override
    public synchronized Long generateNext() {
        if (this.state.hiValue == null || this.state.loValue >= 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Generating new high value as successor to [{}].", (Object)this.state.hiValue);
            }
            try {
                this.withTransaction((state, statement) -> {
                    this.incrementHiValue(statement);
                    this.fetchNextId(state, statement);
                    if (state.hiValue == null) {
                        throw new DAOException("Id table [" + this.idTableName + "] contains no rows, did you call initialize()?");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("New high value is [{}].", (Object)state.hiValue);
                    }
                    state.loValue = -this.blockSize;
                });
            }
            catch (SQLException e) {
                throw new DAOException("Error generating new High value", (Throwable)e);
            }
        }
        Long ret = this.getBaseId() + this.state.loValue++;
        if (log.isDebugEnabled()) {
            log.debug("Generated new ID [{}].", (Object)ret);
        }
        return ret;
    }

    public Long getHiValue() {
        return this.state.hiValue;
    }

    public String getIdTableName() {
        return this.idTableName;
    }

    public void setIdTableName(String idTableName) {
        this.idTableName = idTableName;
    }

    public String getNextIdColumnName() {
        return this.nextIdColumnName;
    }

    public void setNextIdColumnName(String nextIdColumnName) {
        this.nextIdColumnName = nextIdColumnName;
    }

    public String getLoIdColumnName() {
        return this.loIdColumnName;
    }

    public void setLoIdColumnName(String loIdColumnName) {
        this.loIdColumnName = loIdColumnName;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getThreadLocalKey() {
        return this.threadLocalKey;
    }

    public void setThreadLocalKey(String threadLocalKey) {
        this.threadLocalKey = threadLocalKey;
    }

    private final class State {
        private Long hiValue;
        private long loValue;

        public State(Long hiValue, long loValue) {
            this.hiValue = hiValue;
            this.loValue = loValue;
        }

        public State copy() {
            return new State(this.hiValue, this.loValue);
        }
    }

    @FunctionalInterface
    private static interface TransactionFn {
        public void accept(State var1, Statement var2) throws SQLException;
    }
}

