/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.dao;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.reflect.PropertyHelper;
import org.clazzes.util.sql.SQLDialect;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrBasicDAO;
import org.clazzes.util.sql.dao.IIdDAO;
import org.clazzes.util.sql.dao.IdGenerator;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstrIdDAO<T>
extends AbstrBasicDAO<T>
implements IIdDAO<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstrIdDAO.class);
    private final String pkColumn;
    private final Class<T> clazz;
    private final Method idGetter;
    private final Method idSetter;
    private final int sqlTypeOfId;
    private IdGenerator idGenerator;
    private boolean idProvided = false;

    public AbstrIdDAO(Class<T> clazz, String idProperty, String tableName, String ... columns) {
        this(clazz, idProperty, tableName, columns, columns);
    }

    public AbstrIdDAO(Class<T> clazz, String idProperty, String tableName, String[] columns, String[] writableColumns) {
        super(tableName, columns, writableColumns);
        this.pkColumn = columns[0];
        this.clazz = clazz;
        try {
            this.idGetter = this.clazz.getMethod(PropertyHelper.getGetterName((String)idProperty), new Class[0]);
            if (this.idGetter.getReturnType().equals(String.class)) {
                this.sqlTypeOfId = 12;
            } else if (this.idGetter.getReturnType().equals(Long.class) || this.idGetter.getReturnType().equals(Long.TYPE)) {
                this.sqlTypeOfId = -5;
            } else {
                throw new IllegalArgumentException("ID property [" + idProperty + "] for bean class [" + String.valueOf(clazz) + "] is not of type java.lang.Long or java.lang.String");
            }
            this.idSetter = this.clazz.getMethod(PropertyHelper.getSetterName((String)idProperty), this.idGetter.getReturnType());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid ID property [" + idProperty + "] for bean class [" + String.valueOf(clazz) + "] specified", e);
        }
    }

    @Override
    public Serializable getId(T dto) {
        try {
            return (Serializable)this.idGetter.invoke(dto, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error getting ID property for bean class [" + String.valueOf(this.clazz) + "].", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Error getting ID property for bean class [" + String.valueOf(this.clazz) + "].", e);
        }
    }

    @Override
    public Class<? extends Serializable> getIdClass() {
        return this.idGetter.getReturnType();
    }

    protected void setIdOnStatement(PreparedStatement statement, int pos, Object id) throws SQLException {
        if (this.sqlTypeOfId == 12) {
            statement.setString(pos, (String)id);
        } else {
            statement.setLong(pos, ((Number)id).longValue());
        }
    }

    @Override
    public T save(final T dto) {
        if (this.idProvided) {
            return super.save(dto);
        }
        if (this.sqlTypeOfId == 12) {
            try {
                this.idSetter.invoke(dto, this.generateUID());
            }
            catch (IllegalAccessException e) {
                throw new DAOException("Unable to set generated UUID to DTO of type [" + String.valueOf(this.clazz) + "]", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new DAOException("Unable to set generated UUID to DTO of type [" + String.valueOf(this.clazz) + "]", (Throwable)e);
            }
            return super.save(dto);
        }
        if (this.idGenerator == null) {
            String sql = this.getGenerator().insert(this.getTableName(), SQLValue.columnList(this.getTableName(), this.getWritableColumnNames()));
            if (log.isDebugEnabled()) {
                log.debug("executing query [" + sql + "]");
            }
            if (this.sqlTypeOfId == 12) {
                return (T)this.performWithPreparedStatement(sql, new JdbcPreparedStatementAction<T>(){

                    public T perform(PreparedStatement statement) throws SQLException {
                        AbstrIdDAO.this.fillPreparedStatementFromDto(statement, dto);
                        statement.executeUpdate();
                        return dto;
                    }
                });
            }
            return (T)this.performWithPreparedStatement(sql, new String[]{this.pkColumn}, new JdbcPreparedStatementAction<T>(){

                public T perform(PreparedStatement statement) throws SQLException {
                    AbstrIdDAO.this.fillPreparedStatementFromDto(statement, dto);
                    statement.execute();
                    ResultSet rs = statement.getGeneratedKeys();
                    rs.next();
                    try {
                        AbstrIdDAO.this.idSetter.invoke(dto, rs.getLong(1));
                    }
                    catch (IllegalAccessException e) {
                        throw new DAOException("Unable to set generated ID to DTO of type [" + String.valueOf(AbstrIdDAO.this.clazz) + "]", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new DAOException("Unable to set generated ID to DTO of type [" + String.valueOf(AbstrIdDAO.this.clazz) + "]", (Throwable)e);
                    }
                    return dto;
                }
            });
        }
        try {
            this.idSetter.invoke(dto, this.idGenerator.generateNext());
        }
        catch (IllegalAccessException e) {
            throw new DAOException("Unable to set generated ID to DTO of type [" + String.valueOf(this.clazz) + "]", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DAOException("Unable to set generated ID to DTO of type [" + String.valueOf(this.clazz) + "]", (Throwable)e);
        }
        return super.save(dto);
    }

    @Override
    public List<T> saveBatch(final List<T> dtos) {
        if (dtos.size() == 0) {
            return dtos;
        }
        if (this.idProvided) {
            return super.saveBatch(dtos);
        }
        if (this.sqlTypeOfId == 12) {
            try {
                for (T dto : dtos) {
                    this.idSetter.invoke(dto, UUID.randomUUID().toString());
                }
            }
            catch (IllegalAccessException e) {
                throw new DAOException("Unable to set generated UUID to DTO of type [" + String.valueOf(this.clazz) + "]", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new DAOException("Unable to set generated UUID to DTO of type [" + String.valueOf(this.clazz) + "]", (Throwable)e);
            }
            return super.saveBatch(dtos);
        }
        if (this.idGenerator == null) {
            String sql = this.getGenerator().insert(this.getTableName(), SQLValue.columnList(this.getTableName(), this.getWritableColumnNames()));
            if (log.isDebugEnabled()) {
                log.debug("executing query [" + sql + "]");
            }
            return (List)this.performWithPreparedStatement(sql, new String[]{this.pkColumn}, new JdbcPreparedStatementAction<List<T>>(){

                public List<T> perform(PreparedStatement statement) throws SQLException {
                    for (Object dto : dtos) {
                        AbstrIdDAO.this.fillPreparedStatementFromDto(statement, dto);
                        statement.addBatch();
                    }
                    statement.executeBatch();
                    if (AbstrIdDAO.this.getGenerator().getDialect() == SQLDialect.MSSQL) {
                        log.warn("Unable to retrieve auto-generated IDs for MSSQL, see 'mssql-jdbc #245 #358' for details.");
                    } else {
                        ResultSet rs = statement.getGeneratedKeys();
                        try {
                            for (int i = 0; i < dtos.size() && rs.next(); ++i) {
                                Object dto = dtos.get(i);
                                if (log.isDebugEnabled()) {
                                    log.debug("Fetching auto-generated ID for [{}]", dto);
                                }
                                AbstrIdDAO.this.idSetter.invoke(dto, rs.getLong(1));
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Final DTO with auto-generated ID is [{}]", dto);
                            }
                        }
                        catch (IllegalAccessException e) {
                            throw new DAOException("Unable to set generated ID to DTO of type [" + String.valueOf(AbstrIdDAO.this.clazz) + "]", (Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new DAOException("Unable to set generated ID to DTO of type [" + String.valueOf(AbstrIdDAO.this.clazz) + "]", (Throwable)e);
                        }
                    }
                    return dtos;
                }
            });
        }
        try {
            for (T dto : dtos) {
                this.idSetter.invoke(dto, this.idGenerator.generateNext());
            }
        }
        catch (IllegalAccessException e) {
            throw new DAOException("Unable to set generated ID to DTO of type [" + String.valueOf(this.clazz) + "]", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DAOException("Unable to set generated ID to DTO of type [" + String.valueOf(this.clazz) + "]", (Throwable)e);
        }
        return super.saveBatch(dtos);
    }

    @Override
    public int update(final T dto) {
        String sql = this.getGenerator().update(this.getTableName(), SQLValue.columnList(this.getTableName(), this.getWritableColumnNames()), SQLCondition.eq(SQLValue.tableColumn(this.getTableName(), this.pkColumn), SQLValue.INSERT_VALUE));
        if (log.isDebugEnabled()) {
            log.debug("executing query [" + sql + "]");
        }
        return (Integer)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Integer>(){

            public Integer perform(PreparedStatement statement) throws Exception {
                AbstrIdDAO.this.fillPreparedStatementFromDto(statement, dto);
                AbstrIdDAO.this.setIdOnStatement(statement, AbstrIdDAO.this.getWritableColumnNames().length + 1, AbstrIdDAO.this.idGetter.invoke(dto, new Object[0]));
                statement.execute();
                return statement.getUpdateCount();
            }
        });
    }

    @Override
    public int[] updateBatch(final Collection<T> dtos) {
        if (dtos.size() == 0) {
            return new int[0];
        }
        String sql = this.getGenerator().update(this.getTableName(), SQLValue.columnList(this.getTableName(), this.getWritableColumnNames()), SQLCondition.eq(SQLValue.tableColumn(this.getTableName(), this.pkColumn), SQLValue.INSERT_VALUE));
        if (log.isDebugEnabled()) {
            log.debug("executing query [" + sql + "]");
        }
        return (int[])this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<int[]>(){

            public int[] perform(PreparedStatement statement) throws Exception {
                for (Object dto : dtos) {
                    AbstrIdDAO.this.fillPreparedStatementFromDto(statement, dto);
                    AbstrIdDAO.this.setIdOnStatement(statement, AbstrIdDAO.this.getWritableColumnNames().length + 1, AbstrIdDAO.this.idGetter.invoke(dto, new Object[0]));
                    statement.addBatch();
                }
                return statement.executeBatch();
            }
        });
    }

    @Override
    public T get(final Serializable id) {
        SQLCondition cond = SQLCondition.eq(SQLValue.tableColumn(this.getTableName(), this.pkColumn), SQLValue.INSERT_VALUE);
        return super.getUniqueWithCondition(cond, new StatementPreparer(){

            @Override
            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                AbstrIdDAO.this.setIdOnStatement(statement, 1, id);
            }
        });
    }

    @Override
    public List<T> getBatch(Serializable ... ids) {
        return this.getBatch(Arrays.asList(ids));
    }

    @Override
    public List<T> getBatch(Collection<? extends Serializable> ids) {
        if (ids.size() == 0) {
            return new ArrayList();
        }
        SQLFragment[] idValues = new SQLValue[ids.size()];
        int n = 0;
        for (Serializable serializable : ids) {
            idValues[n] = this.getSQLValueForId(serializable);
            ++n;
        }
        SQLCondition condition = SQLCondition.in(SQLValue.tableColumn(this.getTableName(), this.pkColumn), SQLConstruct.commaParenthesis(idValues));
        return super.getListWithCondition(condition, new StatementPreparer(){

            @Override
            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    protected SQLValue getSQLValueForId(Serializable id) {
        if (this.sqlTypeOfId != -5) {
            return SQLValue.stringValue(id.toString());
        }
        Long idAsLong = (Long)id;
        return SQLValue.integerValue(idAsLong);
    }

    @Override
    public boolean delete(final Serializable id) {
        String sql = this.getGenerator().delete(this.getTableName(), SQLCondition.eq(SQLValue.tableColumn(this.getTableName(), this.pkColumn), SQLValue.INSERT_VALUE));
        if (log.isDebugEnabled()) {
            log.debug("executing query [" + sql + "]");
        }
        return (Boolean)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Boolean>(){

            public Boolean perform(PreparedStatement statement) throws Exception {
                AbstrIdDAO.this.setIdOnStatement(statement, 1, id);
                statement.execute();
                return true;
            }
        });
    }

    @Override
    public int[] deleteBatch(final Collection<? extends Serializable> ids) {
        if (ids.size() == 0) {
            return new int[0];
        }
        String sql = this.getGenerator().delete(this.getTableName(), SQLCondition.eq(SQLValue.tableColumn(this.getTableName(), this.pkColumn), SQLValue.INSERT_VALUE));
        if (log.isDebugEnabled()) {
            log.debug("executing query [" + sql + "]");
        }
        return (int[])this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<int[]>(){

            public int[] perform(PreparedStatement statement) throws Exception {
                for (Serializable id : ids) {
                    AbstrIdDAO.this.setIdOnStatement(statement, 1, id);
                    statement.addBatch();
                }
                return statement.executeBatch();
            }
        });
    }

    protected String generateUID() {
        String sql = this.getGenerator().select(this.getTableName(), SQLValue.valueList(SQLValue.tableColumn(this.getTableName(), this.pkColumn)), SQLCondition.eq(SQLValue.tableColumn(this.getTableName(), this.pkColumn), SQLValue.INSERT_VALUE));
        if (log.isDebugEnabled()) {
            log.debug("executing query [" + sql + "]");
        }
        return (String)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<String>(){

            public String perform(PreparedStatement statement) throws Exception {
                String uid = null;
                while (true) {
                    uid = UUID.randomUUID().toString();
                    statement.setString(1, uid);
                    ResultSet rs = statement.executeQuery();
                    if (!rs.next()) break;
                    rs.close();
                }
                return uid;
            }
        });
    }

    public String getPkColumn() {
        return this.pkColumn;
    }

    public Class<T> getEntityClass() {
        return this.clazz;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        if (idGenerator != null && this.sqlTypeOfId != -5) {
            log.warn("The provided ID generator will be ignored for IDs of type String, UUID-generation will be used instead.");
        }
    }

    public void setIdProvided(boolean idProvided) {
        this.idProvided = idProvided;
    }
}

