/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql;

import org.clazzes.util.sql.SQLDialect;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLOrder;
import org.clazzes.util.sql.criteria.SQLValue;

public class SQLStatementGenerator {
    private SQLDialect dialect;

    public SQLStatementGenerator(SQLDialect dialect) {
        this.dialect = dialect;
    }

    public String select(String tableName, SQLValue[] columnNames, SQLCondition condition) {
        return this.selectInternal(tableName, columnNames, condition, null, false);
    }

    public String select(String tableName, SQLValue[] columnNames, SQLCondition condition, SQLOrder[] orders) {
        return this.selectInternal(tableName, columnNames, condition, orders, false);
    }

    public String selectForUpdate(String tableName, SQLValue[] columnNames, SQLCondition condition) {
        return this.selectInternal(tableName, columnNames, condition, null, true);
    }

    public String selectForUpdate(String tableName, SQLValue[] columnNames, SQLCondition condition, SQLOrder[] orders) {
        return this.selectInternal(tableName, columnNames, condition, orders, true);
    }

    protected String selectInternal(String tableName, SQLValue[] columnNames, SQLCondition condition, SQLOrder[] orders, boolean forUpdate) {
        StringBuffer statement = new StringBuffer("SELECT ");
        switch (this.dialect) {
            default: 
        }
        statement.append(columnNames != null && columnNames.length > 0 ? this.columnNameList(columnNames, false) : "*");
        statement.append(" FROM ");
        statement.append(tableName);
        if (condition != null) {
            statement.append(" WHERE ");
            statement.append(condition.toSQL(this.dialect));
        }
        if (orders != null && orders.length > 0) {
            statement.append(" ORDER BY ");
            statement.append(SQLConstruct.commaSeperated(orders).toSQL(this.dialect));
        }
        if (forUpdate) {
            statement.append(" FOR UPDATE");
        }
        return statement.toString();
    }

    public String selectDistinct(String tableName, SQLValue[] columnNames, SQLCondition condition) {
        return this.selectDistinct(tableName, columnNames, condition, null);
    }

    public String selectDistinct(String tableName, SQLValue[] columnNames, SQLCondition condition, SQLOrder[] orders) {
        StringBuffer statement = new StringBuffer("SELECT DISTINCT ");
        switch (this.dialect) {
            default: 
        }
        statement.append(columnNames != null && columnNames.length > 0 ? this.columnNameList(columnNames, false) : "*");
        statement.append(" FROM ");
        statement.append(tableName);
        if (condition != null) {
            statement.append(" WHERE ");
            statement.append(condition.toSQL(this.dialect));
        }
        if (orders != null && orders.length > 0) {
            statement.append(" ORDER BY ");
            statement.append(SQLConstruct.commaSeperated(orders).toSQL(this.dialect));
        }
        return statement.toString();
    }

    public String insert(String tableName, SQLValue[] columnNames) {
        StringBuffer statement = new StringBuffer("INSERT INTO ");
        switch (this.dialect) {
            default: 
        }
        statement.append(tableName);
        statement.append(" (");
        statement.append(this.unqualifiedColumnNameList(columnNames, false));
        statement.append(") VALUES (");
        statement.append(this.placeholderList(columnNames.length));
        statement.append(")");
        return statement.toString();
    }

    public String update(String tableName, SQLValue[] columnNames, SQLCondition condition) {
        StringBuffer statement = new StringBuffer("UPDATE ");
        switch (this.dialect) {
            default: 
        }
        statement.append(tableName);
        statement.append(" SET ");
        statement.append(this.unqualifiedColumnNameList(columnNames, true));
        if (condition != null) {
            statement.append(" WHERE ");
            statement.append(condition.toSQL(this.dialect));
        }
        return statement.toString();
    }

    public String delete(String tableName, SQLCondition condition) {
        StringBuffer statement = new StringBuffer("DELETE FROM ");
        switch (this.dialect) {
            default: 
        }
        statement.append(tableName);
        if (condition != null) {
            statement.append(" WHERE ");
            statement.append(condition.toSQL(this.dialect));
        }
        return statement.toString();
    }

    public String innerJoin(String tableName1, String tableName2, SQLCondition joinCondition, SQLCondition queryCondition, SQLValue[] columnNames) {
        StringBuffer statement = new StringBuffer("SELECT ");
        switch (this.dialect) {
            default: 
        }
        statement.append(columnNames != null && columnNames.length > 0 ? this.columnNameList(columnNames, false) : "*");
        statement.append(" FROM ");
        statement.append(tableName1);
        statement.append(" INNER JOIN ");
        statement.append(tableName2);
        statement.append(" ON ");
        statement.append(joinCondition.toSQL(this.dialect));
        if (queryCondition != null) {
            statement.append(" WHERE ");
            statement.append(queryCondition.toSQL(this.dialect));
        }
        return statement.toString();
    }

    public String columnNameList(SQLValue[] columnNames, boolean placeholders) {
        if (columnNames == null || columnNames.length == 0) {
            return "*";
        }
        StringBuffer result = new StringBuffer();
        switch (this.dialect) {
            default: 
        }
        for (int i = 0; i < columnNames.length; ++i) {
            result.append(columnNames[i].toSQL(this.dialect));
            if (placeholders) {
                result.append("=").append(SQLValue.INSERT_VALUE.toSQL(this.dialect));
            }
            if (i >= columnNames.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String unqualifiedColumnNameList(SQLValue[] columnNames, boolean placeholders) {
        if (columnNames == null || columnNames.length == 0) {
            return "*";
        }
        StringBuffer result = new StringBuffer();
        switch (this.dialect) {
            default: 
        }
        for (int i = 0; i < columnNames.length; ++i) {
            result.append(columnNames[i].toUnqualifiedSQL(this.dialect));
            if (placeholders) {
                result.append("=").append(SQLValue.INSERT_VALUE.toSQL(this.dialect));
            }
            if (i >= columnNames.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String placeholderList(int amount) {
        StringBuffer result = new StringBuffer();
        switch (this.dialect) {
            default: 
        }
        for (int i = 0; i < amount; ++i) {
            result.append(SQLValue.INSERT_VALUE.toSQL(this.dialect));
            if (i >= amount - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(SQLDialect dialect) {
        this.dialect = dialect;
    }
}

