package org.clazzes.util.sql.transactionprovider;

/**
 * Does not do anything about transactions, but it is an empty / null implementation of TransactionProvider.
 * This is handy for e.g. operations which will put their own transaction environments
 * while your managing code has no need to handle some null value.
 */
public class NullTransactionProvider implements TransactionProvider {

    private static class NoClosableTransaction implements ClosableTransaction {
        @Override
        public void willCommit() {
            // noop
        }

        @Override
        public void willRollback() {
            // noop
        }

        @Override
        public void close() throws TransactionException {
            // noop
        }
    }

    @Override
    public ClosableTransaction getTransaction() {
        return new NoClosableTransaction();
    }

    @Override
    public ClosableTransaction getTransaction(int isolationLevel) {
        return new NoClosableTransaction();
    }

    @Override
    public ClosableTransaction getTransaction(String useThreadLocalKey) {
        return new NoClosableTransaction();
    }

    @Override
    public ClosableTransaction getTransaction(String useThreadLocalKey, int isolationLevel) {
        return new NoClosableTransaction();
    }

    @Override
    public boolean isActive() {
        return false;
    }
}
