package org.clazzes.util.sql.transactionprovider;

/**
 * Use the Transaction object inside with-resource - always close it afterwards!
 * If willCommit() was called, it is done at close() time.
 */
public interface ClosableTransaction extends AutoCloseable {
    /**
     * Sets the transaction to be committed at close()
     */
    void willCommit();

    /**
     * Sets the transaction to explicitly rollback at close().
     */
    void willRollback();

    /**
     * Use the Transaction object inside with-resource - always close it afterwards!
     * The commit / rollback is done at close() time.
     */
    @Override
    void close() throws TransactionException;
}
