/***********************************************************
 * $Id$
 * 
 * SQL/DAO utilities of clazzes.org
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sql.dao;

import java.sql.PreparedStatement;
import java.sql.SQLException;

/** Classes that have the capability to fill the placeholders of a prepared statement.
 *  Is meant to be implemented by anonymos classes mainly.  
 */
public interface StatementPreparer {

	/** Given a statement, this method fills the placeholders of that statement. 
	 * @param statement a PreparedStatement
	 * @throws SQLException
	 */
	public void fillInsertValues(PreparedStatement statement) throws SQLException;
}
