/***********************************************************
 * $Id$
 * 
 * SQL/DAO utilities of clazzes.org
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sql.dao;

/**
 * A thread-safe generator for IDs of type {@link Long}.
 */
public interface IdGenerator {

	/**
	 * @return The next ID. If this function is called on a singleton
	 *         instance on a single-node setup, the returned IDs will
	 *         be strictly increasing. On multi-node setups, IDs
	 *         generated on different instances may be generated block-wise
	 *         on each node. (e.g. by a Hi-Lo-Generator)
	 */
	public Long generateNext();
}
