/***********************************************************
 * $Id$
 * 
 * SQL/DAO utilities of clazzes.org
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sql.dao;

import java.util.List;

/**
 * An entity consumer, which appends rthe received entites to a
 * list.
 */
public class AppendListEntityConsumer<T> implements IEntityConsumer<T> {

    final List<T> list;
    
    /**
     * @param list The list to be filled with the received entites.
     */
    public AppendListEntityConsumer(List<T> list) {
        super();
        this.list = list;
    }

    @Override
    public void consumeEntity(T entity) throws Exception {
        
        this.list.add(entity);
    }

    /**
     * @return The list to which eneties are being appended.
     */
    public synchronized List<T> getList() {
        return this.list;
    }

    
    
}
