/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.clazzes.util.aop.IFileDeleter;
import org.clazzes.util.sched.cache.IScratchBucket;
import org.clazzes.util.sched.cache.IScratchFileCache;
import org.clazzes.util.sched.cache.ScratchFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScratchFileCacheImpl
implements IScratchFileCache {
    private static final Logger log = LoggerFactory.getLogger(ScratchFileCacheImpl.class);
    private static final double MB_FAC = 9.5367431640625E-7;
    private double cacheSizeMB;
    private long maxWaitMillis;
    private IFileDeleter fileDeleter;
    private double currentCacheSizeMB;
    private final Map<String, CacheEntry> entriesByKey = new HashMap<String, CacheEntry>();
    private final Map<String, EntryLock> announcedKeys = new HashMap<String, EntryLock>();

    public ScratchFile newScratchFile(File file, String mimeType, String disposition) {
        return new ScratchFile(this.fileDeleter, file, mimeType, disposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addScratchFile(String key, ScratchFile scratchFile) {
        CacheEntry oldEntry;
        double entryMB = (double)scratchFile.getFile().length() * 9.5367431640625E-7;
        EntryLock lock = this.announcedKeys.remove(key);
        if (lock != null) {
            EntryLock entryLock = lock;
            synchronized (entryLock) {
                lock.notifyAll();
            }
        }
        if (entryMB > this.cacheSizeMB * 0.1) {
            if (log.isDebugEnabled()) {
                log.debug("Rejecting too large entry [{}] for key [{}] with size [{}MB].", new Object[]{scratchFile, key, entryMB});
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding entry [{}] for key [{}] with size [{}MB].", new Object[]{scratchFile, key, entryMB});
        }
        if ((oldEntry = this.entriesByKey.put(key, new CacheEntry(key, scratchFile, entryMB))) != null) {
            log.warn("Purging duplicate entry [{}] for key [{}].", (Object)oldEntry.getScratchFile(), (Object)key);
            oldEntry.getScratchFile().deleteAndClose();
            this.currentCacheSizeMB -= oldEntry.getEntryMB();
        }
        this.currentCacheSizeMB += entryMB;
        if (log.isDebugEnabled()) {
            log.debug("Total cache size is now [{}MB].", (Object)this.currentCacheSizeMB);
        }
        if (this.currentCacheSizeMB > this.cacheSizeMB) {
            PriorityQueue<CacheEntry> entriesToBePurged = new PriorityQueue<CacheEntry>(256);
            double toPurgeMB = this.currentCacheSizeMB - this.cacheSizeMB * 0.9;
            double purgedMB = 0.0;
            for (Map.Entry<String, CacheEntry> entry : this.entriesByKey.entrySet()) {
                if (entry.getKey().equals(key)) continue;
                entriesToBePurged.add(entry.getValue());
                purgedMB += entry.getValue().getEntryMB();
                while (purgedMB > toPurgeMB && entriesToBePurged.size() > 1) {
                    CacheEntry leftEntry = (CacheEntry)entriesToBePurged.poll();
                    purgedMB -= leftEntry.getEntryMB();
                }
            }
            for (CacheEntry cacheEntry : entriesToBePurged) {
                if (log.isDebugEnabled()) {
                    log.debug("Garbage collecting entry [{}] for key [{}], last modified at [{}].", new Object[]{cacheEntry.getScratchFile(), cacheEntry.getKey(), cacheEntry.getLastAccess()});
                }
                this.entriesByKey.remove(cacheEntry.getKey());
                this.currentCacheSizeMB -= cacheEntry.getEntryMB();
            }
        }
        return true;
    }

    public synchronized void cancelAnnouncement(String key) {
        EntryLock lock = this.announcedKeys.remove(key);
        if (lock != null) {
            if (log.isDebugEnabled()) {
                log.debug("Cancelling announcement for key [{}].", (Object)key);
            }
            lock.finish();
        }
    }

    private synchronized Object getScratchFileOrLock(String key) {
        CacheEntry entry = this.entriesByKey.get(key);
        if (entry == null) {
            EntryLock lock;
            if (log.isDebugEnabled()) {
                log.debug("Found no entry for key [{}].", (Object)key);
            }
            if ((lock = this.announcedKeys.get(key)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Announcing creation of entry for key [{}].", (Object)key);
                }
                this.announcedKeys.put(key, new EntryLock());
                return null;
            }
            return lock;
        }
        entry.touch();
        return entry.getScratchFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScratchFile getScratchFile(String key) throws InterruptedException {
        Object scratchFileOrLock = this.getScratchFileOrLock(key);
        if (scratchFileOrLock == null) {
            return null;
        }
        if (scratchFileOrLock.getClass() == EntryLock.class) {
            if (log.isDebugEnabled()) {
                log.debug("Waiting [{}ms] for another thread to provide data for key [{}]...", (Object)this.maxWaitMillis, (Object)key);
            }
            EntryLock lock = (EntryLock)scratchFileOrLock;
            lock.waitForFinish(this.maxWaitMillis);
            ScratchFileCacheImpl scratchFileCacheImpl = this;
            synchronized (scratchFileCacheImpl) {
                CacheEntry entry = this.entriesByKey.get(key);
                if (entry == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("No data after wait for [{}ms] for another thread to provide data for key [{}].", (Object)this.maxWaitMillis, (Object)key);
                    }
                    return null;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Another thread provided entry [{}] for key [{}].", (Object)entry.getScratchFile(), (Object)key);
                }
                entry.touch();
                return entry.getScratchFile();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Found existing entry [{}] for key [{}].", scratchFileOrLock, (Object)key);
        }
        return (ScratchFile)scratchFileOrLock;
    }

    public synchronized double getCurrentCacheSizeMB() {
        return this.currentCacheSizeMB;
    }

    public synchronized int getAnnouncementCount() {
        return this.announcedKeys.size();
    }

    public synchronized int getEntryCount() {
        return this.entriesByKey.size();
    }

    public synchronized void destroy() {
        log.info("Purging [{}] cache entries with a total size of [{}MB].", (Object)this.entriesByKey.size(), (Object)this.currentCacheSizeMB);
        for (Map.Entry<String, CacheEntry> e : this.entriesByKey.entrySet()) {
            e.getValue().getScratchFile().deleteAndClose();
        }
        this.entriesByKey.clear();
        this.currentCacheSizeMB = 0.0;
    }

    @Override
    public IScratchBucket getBucket(String key) throws InterruptedException {
        return new ScratchBucketImpl(key, this.getScratchFile(key));
    }

    public double getCacheSizeMB() {
        return this.cacheSizeMB;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public IFileDeleter getFileDeleter() {
        return this.fileDeleter;
    }

    public void setCacheSizeMB(double cacheSizeMB) {
        this.cacheSizeMB = cacheSizeMB;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setFileDeleter(IFileDeleter fileDeleter) {
        this.fileDeleter = fileDeleter;
    }

    private static final class CacheEntry
    implements Comparable<CacheEntry> {
        private final String key;
        private final ScratchFile scratchFile;
        private final double entryMB;
        private long lastAccess;

        public CacheEntry(String key, ScratchFile scratchFile, double entryMB) {
            this.key = key;
            this.scratchFile = scratchFile;
            this.entryMB = entryMB;
            this.touch();
        }

        public String getKey() {
            return this.key;
        }

        public ScratchFile getScratchFile() {
            return this.scratchFile;
        }

        public double getEntryMB() {
            return this.entryMB;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public void touch() {
            this.lastAccess = System.currentTimeMillis();
        }

        @Override
        public int compareTo(CacheEntry o) {
            if (this.lastAccess < o.lastAccess) {
                return 1;
            }
            if (this.lastAccess > o.lastAccess) {
                return -1;
            }
            return 0;
        }
    }

    private static final class EntryLock {
        private boolean finished;

        private EntryLock() {
        }

        public synchronized void waitForFinish(long timeout) throws InterruptedException {
            if (!this.finished) {
                this.wait(timeout);
            }
        }

        public synchronized void finish() {
            this.finished = true;
            this.notifyAll();
        }
    }

    private class ScratchBucketImpl
    implements IScratchBucket {
        private final String key;
        private ScratchFile scratchFile;
        private boolean closeScratchFile;
        private boolean closed;

        public ScratchBucketImpl(String key, ScratchFile scratchFile) {
            this.key = key;
            this.scratchFile = scratchFile;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                if (this.scratchFile == null) {
                    ScratchFileCacheImpl.this.cancelAnnouncement(this.key);
                } else if (this.closeScratchFile) {
                    this.scratchFile.deleteAndClose();
                }
            }
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public ScratchFile getScratchFile() {
            return this.scratchFile;
        }

        @Override
        public ScratchFile provideScratchFile(File file, String mimeType, String disposition) {
            this.scratchFile = ScratchFileCacheImpl.this.newScratchFile(file, mimeType, disposition);
            this.closeScratchFile = !ScratchFileCacheImpl.this.addScratchFile(this.key, this.scratchFile);
            return this.scratchFile;
        }
    }
}

