/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Destroyable;
import org.aopalliance.intercept.Joinpoint;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.HasCallback;
import org.clazzes.util.sched.IJobStatus;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.clazzes.util.sched.ITimedJob;
import org.clazzes.util.sched.JoinpointCallableAdapter;
import org.clazzes.util.sched.api.ILoggingCallback;
import org.clazzes.util.sched.impl.CallbackHelper;
import org.clazzes.util.sched.impl.JobStatusImpl;
import org.clazzes.util.sched.impl.JobStatusWithCallbackImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneTimeSchedulerImpl
implements IOneTimeScheduler {
    private static final Logger log = LoggerFactory.getLogger(OneTimeSchedulerImpl.class);
    private ExecutorService executorService;
    private long gcInterval = 60000L;
    private long resultLifeTime = 60000L;
    private Map<String, Object> threadLocalValues;
    private Map<UUID, JobStatusImpl> jobs;
    private ScheduledExecutorService gcService;
    private boolean ownGcService;
    private ScheduledFuture<?> gcFuture;

    private int getNumberOfRunningJobs() {
        int number = 0;
        for (JobStatusImpl impl : this.jobs.values()) {
            if (impl.isDone()) continue;
            ++number;
        }
        return number;
    }

    private int getNumberOfFinishedJobs() {
        int number = 0;
        for (JobStatusImpl impl : this.jobs.values()) {
            if (!impl.isDone()) continue;
            ++number;
        }
        return number;
    }

    private Map<String, Object> propagateThreadLocals(Object delegate) {
        if (this.threadLocalValues == null) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(this.threadLocalValues.size());
        for (Map.Entry<String, Object> e : this.threadLocalValues.entrySet()) {
            Object v = e.getValue();
            if (v == null && (v = ThreadLocalManager.getBoundResource((String)e.getKey())) == null && "org.clazzes.util.sched::ILoggingCallback".equals(e.getKey())) {
                v = CallbackHelper.getCallbackOfType(delegate, ILoggingCallback.class);
            }
            if (v == null) continue;
            ret.put(e.getKey(), v);
        }
        return ret;
    }

    private static void closeJob(UUID jobId, JobStatusImpl jobStatus) {
        Object res = jobStatus.getResult();
        if (res instanceof Closeable) {
            Closeable cr = (Closeable)res;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Closing closeable result [{}] of job [{}].", (Object)cr, (Object)jobId);
                }
                cr.close();
            }
            catch (IOException e) {
                log.warn("I/O error closing closeable result of job [" + String.valueOf(jobId) + "] upon garbage collection", (Throwable)e);
            }
        }
        jobStatus.destroyIfNotRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gc() {
        long now = System.currentTimeMillis();
        OneTimeSchedulerImpl oneTimeSchedulerImpl = this;
        synchronized (oneTimeSchedulerImpl) {
            if (log.isDebugEnabled()) {
                log.debug("Called gc() at " + now + ", with a total of " + this.jobs.size() + " existing ( " + this.getNumberOfRunningJobs() + " running, " + this.getNumberOfFinishedJobs() + " finished)");
            }
            Iterator<Map.Entry<UUID, JobStatusImpl>> it = this.jobs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, JobStatusImpl> entry = it.next();
                if (!entry.getValue().isDone() || entry.getValue().getFinishedMillis() + this.resultLifeTime >= now) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Garbage collecting job " + String.valueOf(entry.getKey()));
                }
                it.remove();
                OneTimeSchedulerImpl.closeJob(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (log.isInfoEnabled()) {
            log.info("Called start()");
        }
        OneTimeSchedulerImpl oneTimeSchedulerImpl = this;
        synchronized (oneTimeSchedulerImpl) {
            if (this.jobs != null) {
                throw new IllegalStateException("Try to start an already running one-time scheduler.");
            }
            this.jobs = new HashMap<UUID, JobStatusImpl>();
            if (this.gcService == null) {
                if (this.executorService instanceof ScheduledExecutorService) {
                    this.gcService = (ScheduledExecutorService)this.executorService;
                } else {
                    this.gcService = Executors.newSingleThreadScheduledExecutor();
                    this.ownGcService = true;
                }
            }
            this.gcFuture = this.gcService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    OneTimeSchedulerImpl.this.gc();
                }
            }, this.gcInterval, this.gcInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelInternals() {
        this.jobs = null;
        if (this.ownGcService) {
            this.gcService.shutdownNow();
            this.gcService = null;
            this.gcFuture = null;
            this.ownGcService = false;
        } else {
            this.gcFuture.cancel(true);
            this.gcFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownGracefully(boolean hard) {
        Map<UUID, JobStatusImpl> jobsToCancel;
        OneTimeSchedulerImpl oneTimeSchedulerImpl = this;
        synchronized (oneTimeSchedulerImpl) {
            if (this.jobs == null) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info("Called shutdownGracefully(" + hard + "), with a total of " + this.jobs.size() + " existing (" + this.getNumberOfRunningJobs() + " running, " + this.getNumberOfFinishedJobs() + " finished)");
            }
            jobsToCancel = this.jobs;
            this.cancelInternals();
        }
        for (Map.Entry entry : jobsToCancel.entrySet()) {
            Future<?> future = ((JobStatusImpl)entry.getValue()).getFuture();
            if (future != null && !future.isDone()) {
                try {
                    ((JobStatusImpl)entry.getValue()).getFuture().cancel(hard);
                }
                catch (Throwable e) {
                    log.warn("Caught exception cancelling job [" + String.valueOf(entry.getKey()) + "] upon shutdown of scheduler", e);
                }
            }
            OneTimeSchedulerImpl.closeJob((UUID)entry.getKey(), (JobStatusImpl)entry.getValue());
        }
    }

    public void shutdown() {
        this.shutdownGracefully(false);
    }

    public void shutdownNow() {
        this.shutdownGracefully(true);
    }

    private static JobStatusImpl makeJobStatus(Object hint, UUID uuid) {
        JobStatusWithCallbackImpl ret = hint instanceof HasCallback ? new JobStatusWithCallbackImpl((HasCallback)hint, uuid) : new JobStatusWithCallbackImpl(uuid);
        if (hint instanceof Destroyable) {
            ret.setDestroyable((Destroyable)hint);
        }
        return ret;
    }

    @Override
    public UUID scheduleJob(Runnable runnable) {
        return this.scheduleJobInner(runnable, Executors.callable(runnable));
    }

    @Override
    public UUID scheduleJob(Joinpoint joinpoint) {
        return this.scheduleJobInner(joinpoint, new JoinpointCallableAdapter(joinpoint));
    }

    private Long submitScheduledJobIfNecessary(WrappedCallable<?> wrappedCallable) {
        if (wrappedCallable.getTimedJob() == null) {
            wrappedCallable.getStatus().setFuture(this.executorService.submit(wrappedCallable));
            return null;
        }
        if (this.executorService instanceof ScheduledExecutorService) {
            ScheduledExecutorService executorService = (ScheduledExecutorService)this.executorService;
            Long nextExecutionDelay = null;
            try {
                nextExecutionDelay = wrappedCallable.getTimedJob().getNextExecutionDelay();
            }
            catch (Throwable e) {
                log.error("Caught exception calling ITimedJob.getNextExecutionDelay() on Job with uuid [" + String.valueOf(wrappedCallable.getStatus().getUUID()) + "], job will not be scheduled", e);
            }
            if (nextExecutionDelay != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Scheduling job with uuid [{}] with delay [{}s].", (Object)wrappedCallable.getStatus().getUUID(), (Object)(nextExecutionDelay.doubleValue() * 0.001));
                }
                wrappedCallable.getStatus().setFuture(executorService.schedule(wrappedCallable, (long)nextExecutionDelay, TimeUnit.MILLISECONDS));
            } else if (log.isInfoEnabled()) {
                log.info("Not scheduling job with uuid [{}] since it does not wish to do so.", (Object)wrappedCallable.getStatus().getUUID());
            }
            return nextExecutionDelay;
        }
        String msg = "If a ITimedJob is passed to a OneTimeScheduler, a ScheduledExecutorService has to be used.";
        log.error(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public <V> UUID scheduleJob(Callable<V> callable) {
        return this.scheduleJobInner(callable, callable);
    }

    @Override
    public <V> void scheduleJob(UUID id, Callable<V> callable) {
        this.scheduleJobInner(id, callable, callable);
    }

    private <V> UUID scheduleJobInner(Object delegate, Callable<V> callable) {
        UUID id = UUID.randomUUID();
        return this.scheduleJobInner(id, delegate, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> UUID scheduleJobInner(UUID id, Object delegate, Callable<V> callable) {
        WrappedCallable<V> wrappedCallable;
        Long nextExecutionDelay;
        if (log.isDebugEnabled()) {
            log.debug("Scheduling callable job [" + String.valueOf(id) + "].");
        }
        JobStatusImpl status = OneTimeSchedulerImpl.makeJobStatus(delegate, id);
        OneTimeSchedulerImpl oneTimeSchedulerImpl = this;
        synchronized (oneTimeSchedulerImpl) {
            if (this.jobs == null) {
                throw new IllegalStateException("Try to schedule a job on a stopped one-time scheduler.");
            }
            JobStatusImpl conflict = this.jobs.putIfAbsent(id, status);
            if (conflict != null) {
                throw new IllegalArgumentException("Try to schedule job with duplicate ID [" + String.valueOf(id) + "]");
            }
        }
        ITimedJob timedJob = null;
        if (delegate instanceof ITimedJob) {
            timedJob = (ITimedJob)delegate;
        }
        if ((nextExecutionDelay = this.submitScheduledJobIfNecessary(wrappedCallable = new WrappedCallable<V>(callable, timedJob, status, this.propagateThreadLocals(delegate)))) != null) {
            status.setResult(null, nextExecutionDelay);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UUID> getAllJobsIds() {
        if (log.isDebugEnabled()) {
            log.debug("Called getAllJobsIds");
        }
        OneTimeSchedulerImpl oneTimeSchedulerImpl = this;
        synchronized (oneTimeSchedulerImpl) {
            if (this.jobs == null) {
                return null;
            }
            Set<UUID> keys = this.jobs.keySet();
            ArrayList<UUID> ret = new ArrayList<UUID>(keys.size());
            ret.addAll(keys);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobStatusImpl getJobStatusImpl(UUID jobId) {
        OneTimeSchedulerImpl oneTimeSchedulerImpl = this;
        synchronized (oneTimeSchedulerImpl) {
            if (this.jobs == null) {
                return null;
            }
            return this.jobs.get(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJobStatus getJobStatus(UUID jobId) {
        OneTimeSchedulerImpl oneTimeSchedulerImpl = this;
        synchronized (oneTimeSchedulerImpl) {
            if (this.jobs == null) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("Called getJobStatus for job " + String.valueOf(jobId) + "(" + this.jobs.size() + " existing (" + this.getNumberOfRunningJobs() + " running, " + this.getNumberOfFinishedJobs() + " finished)");
            }
            return this.jobs.get(jobId);
        }
    }

    @Override
    public IJobStatus waitForFinish(UUID jobId) throws InterruptedException, ExecutionException {
        JobStatusImpl status;
        if (log.isDebugEnabled()) {
            log.debug("Called waitForFinish() for job " + String.valueOf(jobId));
        }
        if ((status = this.getJobStatusImpl(jobId)) != null) {
            Future<?> future = status.getFuture();
            future.get();
        }
        return status;
    }

    @Override
    public IJobStatus waitForFinish(UUID jobId, long timeoutMillis) throws InterruptedException, ExecutionException, TimeoutException {
        JobStatusImpl status;
        if (log.isDebugEnabled()) {
            log.debug("Called waitForFinish() for job " + String.valueOf(jobId));
        }
        if ((status = this.getJobStatusImpl(jobId)) != null) {
            Future<?> future = status.getFuture();
            future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return status;
    }

    @Override
    public IJobStatus cancelJob(UUID jobId, boolean mayInterrupt) {
        JobStatusImpl status;
        if (log.isDebugEnabled()) {
            log.debug("Called cancelJob for job " + String.valueOf(jobId) + ", mayInterrupt is " + mayInterrupt);
        }
        if ((status = this.getJobStatusImpl(jobId)) != null) {
            Future<?> future = status.getFuture();
            future.cancel(mayInterrupt);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJobStatus purgeResult(UUID jobId) {
        if (log.isDebugEnabled()) {
            log.debug("Called purgeResult for job " + String.valueOf(jobId));
        }
        OneTimeSchedulerImpl oneTimeSchedulerImpl = this;
        synchronized (oneTimeSchedulerImpl) {
            JobStatusImpl status;
            JobStatusImpl jobStatusImpl = status = this.jobs == null ? null : this.jobs.get(jobId);
            if (status != null) {
                if (status.isDone()) {
                    this.jobs.remove(jobId);
                    OneTimeSchedulerImpl.closeJob(jobId, status);
                } else if (log.isDebugEnabled()) {
                    log.debug("==> Not purging job [{}] since it is not yet done.", (Object)jobId);
                }
            }
            return status;
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ScheduledExecutorService getGcService() {
        return this.gcService;
    }

    public void setGcService(ScheduledExecutorService gcService) {
        if (this.ownGcService) {
            throw new IllegalStateException("Cannot override internal garbage collector service after start() has been called.");
        }
        this.gcService = gcService;
    }

    public long getGcInterval() {
        return this.gcInterval;
    }

    public void setGcInterval(long gcInterval) {
        this.gcInterval = gcInterval;
    }

    public long getResultLifeTime() {
        return this.resultLifeTime;
    }

    public void setResultLifeTime(long resultLifeTime) {
        this.resultLifeTime = resultLifeTime;
    }

    public Map<String, Object> getThreadLocalValues() {
        return this.threadLocalValues;
    }

    public void setThreadLocalValues(Map<String, Object> threadLocalValues) {
        this.threadLocalValues = threadLocalValues;
    }

    private class WrappedCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;
        private final JobStatusImpl status;
        private final Map<String, Object> threadLocalValues;
        private final ITimedJob timedJob;

        public WrappedCallable(Callable<V> delegate, ITimedJob timedJob, JobStatusImpl status, Map<String, Object> threadLocalValues) {
            this.delegate = delegate;
            this.timedJob = timedJob;
            this.status = status;
            this.threadLocalValues = threadLocalValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() {
            if (this.threadLocalValues != null) {
                for (Map.Entry<String, Object> e : this.threadLocalValues.entrySet()) {
                    ThreadLocalManager.bindResource((String)e.getKey(), (Object)e.getValue());
                }
            }
            this.status.setRunning(true);
            V ret = null;
            Long nextExecutionDelay = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("WrappedCallable.call called for uuid " + this.status.getUUID().toString());
                }
                ret = this.delegate.call();
                if (log.isDebugEnabled()) {
                    log.debug("WrappedCallable.call completed for uuid " + this.status.getUUID().toString());
                }
                if (this.timedJob != null) {
                    nextExecutionDelay = OneTimeSchedulerImpl.this.submitScheduledJobIfNecessary(this);
                }
                this.status.setResult(ret, nextExecutionDelay);
            }
            catch (Throwable e) {
                log.error("WrappedCallable caught exception for uuid " + this.status.getUUID().toString(), e);
                if (this.timedJob != null) {
                    nextExecutionDelay = OneTimeSchedulerImpl.this.submitScheduledJobIfNecessary(this);
                }
                this.status.setException(e, nextExecutionDelay);
            }
            finally {
                if (this.threadLocalValues != null) {
                    for (String k : this.threadLocalValues.keySet()) {
                        ThreadLocalManager.unbindResource((String)k);
                    }
                }
            }
            return ret;
        }

        private JobStatusImpl getStatus() {
            return this.status;
        }

        private ITimedJob getTimedJob() {
            return this.timedJob;
        }
    }
}

