/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.impl;

import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.api.ILoggingCallback;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class LoggingCallbackLogger
implements Logger {
    private final Logger delegate;

    protected static final ILoggingCallback getLoggingCallback() {
        return (ILoggingCallback)ThreadLocalManager.getBoundResource((String)"org.clazzes.util.sched::ILoggingCallback");
    }

    public LoggingCallbackLogger(Logger delegate) {
        this.delegate = delegate;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public void trace(String msg) {
        this.delegate.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.delegate.trace(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.delegate.trace(format, arg1, arg2);
    }

    public void trace(String format, Object ... argArray) {
        this.delegate.trace(format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.delegate.trace(msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.delegate.trace(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.delegate.trace(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.trace(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.delegate.trace(marker, format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.delegate.trace(marker, msg, t);
    }

    protected String formatExceptionMsg(String msg, Throwable t) {
        return msg + ": " + t.toString();
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    protected void debugToCallback(String msg) {
        ILoggingCallback cb = LoggingCallbackLogger.getLoggingCallback();
        if (cb != null) {
            cb.debug(msg);
        }
    }

    protected void debugToCallback(String msg, Throwable t) {
        ILoggingCallback cb = LoggingCallbackLogger.getLoggingCallback();
        if (cb != null) {
            cb.debug(this.formatExceptionMsg(msg, t));
        }
    }

    public void debug(String msg) {
        this.delegate.debug(msg);
        this.debugToCallback(msg);
    }

    public void debug(String format, Object arg) {
        this.debug(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void debug(String format, Object ... argArray) {
        this.debug(MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage());
    }

    public void debug(String msg, Throwable t) {
        this.delegate.debug(msg, t);
        this.debugToCallback(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.delegate.debug(marker, msg);
        this.debugToCallback(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(marker, MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(marker, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void debug(Marker marker, String format, Object ... argArray) {
        this.debug(marker, MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage());
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.delegate.debug(marker, msg, t);
        this.debugToCallback(msg, t);
    }

    protected void infoToCallback(String msg) {
        ILoggingCallback cb = LoggingCallbackLogger.getLoggingCallback();
        if (cb != null) {
            cb.info(msg);
        }
    }

    protected void infoToCallback(String msg, Throwable t) {
        ILoggingCallback cb = LoggingCallbackLogger.getLoggingCallback();
        if (cb != null) {
            cb.info(this.formatExceptionMsg(msg, t));
        }
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void info(String msg) {
        this.delegate.info(msg);
        this.infoToCallback(msg);
    }

    public void info(String format, Object arg) {
        this.info(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void info(String format, Object ... argArray) {
        this.info(MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage());
    }

    public void info(String msg, Throwable t) {
        this.delegate.info(msg, t);
        this.infoToCallback(msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.delegate.info(marker, msg);
        this.infoToCallback(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(marker, MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(marker, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void info(Marker marker, String format, Object ... argArray) {
        this.info(marker, MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage());
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.delegate.info(marker, msg, t);
        this.infoToCallback(msg, t);
    }

    protected void warnToCallback(String msg) {
        ILoggingCallback cb = LoggingCallbackLogger.getLoggingCallback();
        if (cb != null) {
            cb.warning(msg);
        }
    }

    protected void warnToCallback(String msg, Throwable t) {
        ILoggingCallback cb = LoggingCallbackLogger.getLoggingCallback();
        if (cb != null) {
            cb.warning(this.formatExceptionMsg(msg, t));
        }
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public void warn(String msg) {
        this.delegate.warn(msg);
        this.warnToCallback(msg);
    }

    public void warn(String format, Object arg) {
        this.warn(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void warn(String format, Object ... argArray) {
        this.warn(MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage());
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void warn(String msg, Throwable t) {
        this.delegate.warn(msg, t);
        this.warnToCallback(msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.delegate.warn(marker, msg);
        this.warnToCallback(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(marker, MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(marker, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void warn(Marker marker, String format, Object ... argArray) {
        this.warn(marker, MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage());
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.delegate.warn(marker, msg, t);
        this.warnToCallback(msg, t);
    }

    protected void errorToCallback(String msg) {
        ILoggingCallback cb = LoggingCallbackLogger.getLoggingCallback();
        if (cb != null) {
            cb.error(msg);
        }
    }

    protected void errorToCallback(String msg, Throwable t) {
        ILoggingCallback cb = LoggingCallbackLogger.getLoggingCallback();
        if (cb != null) {
            cb.error(this.formatExceptionMsg(msg, t));
        }
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public void error(String msg) {
        this.delegate.error(msg);
        this.errorToCallback(msg);
    }

    public void error(String format, Object arg) {
        this.error(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void error(String format, Object ... argArray) {
        this.error(MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage());
    }

    public void error(String msg, Throwable t) {
        this.delegate.error(msg, t);
        this.errorToCallback(msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.delegate.error(marker, msg);
        this.errorToCallback(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(marker, MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(marker, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void error(Marker marker, String format, Object ... argArray) {
        this.error(marker, MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage());
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.delegate.error(marker, msg, t);
        this.errorToCallback(msg, t);
    }
}

