/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.impl;

import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.sched.api.ILoggingCallback;
import org.clazzes.util.sched.api.LogMessage;
import org.clazzes.util.sched.api.LogPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCallbackImpl
implements ILoggingCallback {
    private static final Logger log = LoggerFactory.getLogger(LoggingCallbackImpl.class);
    private static final int DEFAULT_MAX_CACHED_MESSAGES = 1000;
    private final int maxCachedMessages;
    private List<LogMessage> logMessages;
    private boolean hasOverflown;

    public LoggingCallbackImpl(int maxCachedMessages) {
        this.maxCachedMessages = maxCachedMessages;
    }

    public LoggingCallbackImpl() {
        this.maxCachedMessages = 1000;
    }

    protected synchronized void addMessage(LogPriority pri, String msg) {
        if (this.hasOverflown) {
            return;
        }
        if (this.logMessages == null) {
            this.logMessages = new ArrayList<LogMessage>(this.maxCachedMessages);
        } else if (this.logMessages.size() >= this.maxCachedMessages) {
            log.warn("More than [{}] messages cached in memory, did your client starve?", (Object)this.maxCachedMessages);
            this.hasOverflown = true;
            return;
        }
        LogMessage lm = new LogMessage();
        lm.setTimestamp(System.currentTimeMillis());
        lm.setPriority(pri);
        lm.setMessage(msg);
        this.logMessages.add(lm);
    }

    @Override
    public void ok(String msg) {
        this.addMessage(LogPriority.OK, msg);
    }

    @Override
    public void debug(String msg) {
        this.addMessage(LogPriority.DEBUG, msg);
    }

    @Override
    public void info(String msg) {
        this.addMessage(LogPriority.INFO, msg);
    }

    @Override
    public void warning(String msg) {
        this.addMessage(LogPriority.WARN, msg);
    }

    @Override
    public void error(String msg) {
        this.addMessage(LogPriority.ERROR, msg);
    }

    public int getMaxCachedMessages() {
        return this.maxCachedMessages;
    }

    @Override
    public synchronized List<LogMessage> getLastLogMessages() {
        try {
            List<LogMessage> list = this.logMessages;
            return list;
        }
        finally {
            this.logMessages = null;
            this.hasOverflown = false;
        }
    }
}

