/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.impl;

import java.util.UUID;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.i18n.Messages;
import org.clazzes.util.sched.IJobStatus;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.clazzes.util.sched.api.IJobStatusService;
import org.clazzes.util.sched.api.ILoggingCallback;
import org.clazzes.util.sched.api.JobStatusDTO;
import org.clazzes.util.sched.impl.CallbackHelper;
import org.clazzes.util.sched.impl.SchedUtilMessages;

public class JobStatusServiceImpl
implements IJobStatusService {
    private IOneTimeScheduler oneTimeScheduler;
    private boolean allowCancelTimedJob;

    private static final JobStatusDTO makeJobStatusDTO(IJobStatus status) {
        JobStatusDTO ret = null;
        if (status != null) {
            ILoggingCallback cb;
            ret = new JobStatusDTO();
            ret.setDone(status.isDone());
            ret.setFinishedMillis(status.getFinishedMillis());
            ret.setNextExecutionDelay(status.getNextExecutionDelay());
            ret.setResult(status.getResult());
            if (status.getException() != null) {
                String msg = status.getException().toString();
                ret.setExceptionMessage(msg);
            }
            if ((cb = CallbackHelper.getCallbackOfType(status, ILoggingCallback.class)) != null) {
                ret.setLastLogMessages(cb.getLastLogMessages());
            }
        }
        return ret;
    }

    @Override
    public JobStatusDTO getJobStatus(UUID jobId) {
        IJobStatus status = this.oneTimeScheduler.getJobStatus(jobId);
        return JobStatusServiceImpl.makeJobStatusDTO(status);
    }

    @Override
    public JobStatusDTO waitForJob(UUID jobId, long timeout) {
        IJobStatus status;
        try {
            status = this.oneTimeScheduler.waitForFinish(jobId, timeout);
        }
        catch (Exception e) {
            status = this.oneTimeScheduler.getJobStatus(jobId);
        }
        return JobStatusServiceImpl.makeJobStatusDTO(status);
    }

    @Override
    public JobStatusDTO cancelJob(UUID jobId) {
        IJobStatus status;
        if (this.allowCancelTimedJob) {
            status = this.oneTimeScheduler.cancelJob(jobId, true);
            ILoggingCallback cb = CallbackHelper.getCallbackOfType(status, ILoggingCallback.class);
            if (cb != null) {
                Messages i18n = SchedUtilMessages.getMessages(ThreadLocalManager.getLoginLocale());
                cb.warning(i18n.formatString("jobInterruptedByUser", new Object[]{jobId}));
            }
        } else {
            status = this.oneTimeScheduler.getJobStatus(jobId);
            if (status.getNextExecutionDelay() != null) {
                ILoggingCallback cb = CallbackHelper.getCallbackOfType(status, ILoggingCallback.class);
                if (cb != null) {
                    Messages i18n = SchedUtilMessages.getMessages(ThreadLocalManager.getLoginLocale());
                    cb.warning(i18n.formatString("timedJobCancelDisabled", new Object[]{jobId}));
                }
            } else {
                status = this.oneTimeScheduler.cancelJob(jobId, true);
                ILoggingCallback cb = CallbackHelper.getCallbackOfType(status, ILoggingCallback.class);
                if (cb != null) {
                    Messages i18n = SchedUtilMessages.getMessages(ThreadLocalManager.getLoginLocale());
                    cb.warning(i18n.formatString("jobInterruptedByUser", new Object[]{jobId}));
                }
            }
        }
        return JobStatusServiceImpl.makeJobStatusDTO(status);
    }

    public IOneTimeScheduler getOneTimeScheduler() {
        return this.oneTimeScheduler;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public boolean isAllowCancelTimedJob() {
        return this.allowCancelTimedJob;
    }

    public void setAllowCancelTimedJob(boolean allowCancelTimedJob) {
        this.allowCancelTimedJob = allowCancelTimedJob;
    }
}

