/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.impl;

import java.util.UUID;
import java.util.concurrent.Future;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.clazzes.util.sched.IJobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobStatusImpl
implements IJobStatus {
    private static final Logger log = LoggerFactory.getLogger(JobStatusImpl.class);
    private Future<?> future = null;
    private Object result = null;
    private Throwable exception = null;
    private boolean running;
    private long finishedMillis = -1L;
    private Long nextExecutionDelay;
    private UUID uuid;
    private Destroyable destroyable;

    public JobStatusImpl(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public boolean isCancelled() {
        if (this.future == null) {
            return false;
        }
        return this.future.isCancelled();
    }

    @Override
    public synchronized boolean isDone() {
        if (this.running) {
            return false;
        }
        if (this.future == null) {
            return false;
        }
        return this.future.isDone();
    }

    @Override
    public synchronized Object getResult() {
        return this.result;
    }

    @Override
    public synchronized Throwable getException() {
        return this.exception;
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }

    protected synchronized void setResult(Object result, Long nextExecutionDelay) {
        this.result = result;
        this.running = false;
        this.finishedMillis = System.currentTimeMillis();
        this.nextExecutionDelay = nextExecutionDelay;
        this.destroyInternal(false);
    }

    protected synchronized void setException(Throwable exception, Long nextExecutionDelay) {
        this.exception = exception;
        this.running = false;
        this.finishedMillis = System.currentTimeMillis();
        this.nextExecutionDelay = nextExecutionDelay;
        this.destroyInternal(false);
    }

    protected void destroyIfNotRunning() {
        if (!this.running) {
            this.destroyInternal(true);
        }
    }

    @Override
    public synchronized Long getNextExecutionDelay() {
        return this.nextExecutionDelay;
    }

    public void setFuture(Future<?> future) {
        this.future = future;
    }

    @Override
    public long getFinishedMillis() {
        return this.finishedMillis;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    protected Destroyable getDestroyable() {
        return this.destroyable;
    }

    protected void setDestroyable(Destroyable destroyable) {
        this.destroyable = destroyable;
    }

    private void destroyInternal(boolean leftOver) {
        if (this.destroyable != null && !this.destroyable.isDestroyed()) {
            log.info("Destroying job [" + String.valueOf(this.uuid) + "] " + (leftOver ? "upon garbage collection." : "upon termination."));
            try {
                this.destroyable.destroy();
            }
            catch (DestroyFailedException e) {
                log.warn("Failure destroying job [" + String.valueOf(this.uuid) + "]", (Throwable)e);
            }
        }
    }
}

