/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.impl;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Destroyable;
import org.aopalliance.intercept.Joinpoint;
import org.clazzes.util.aop.ProxyFactory;
import org.clazzes.util.sched.HasCallback;
import org.clazzes.util.sched.IJobStatus;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.clazzes.util.sched.ITimedJob;

public class InterceptedOneTimeScheduler
implements IOneTimeScheduler {
    private IOneTimeScheduler delegate;
    private ProxyFactory proxyFactory;
    private boolean interceptNextExecutionDelay;

    private Object interceptJob(Object job, Class<?> base) {
        int nifaces = 1;
        int nintercepted = 1;
        if (job instanceof HasCallback) {
            ++nifaces;
        }
        if (job instanceof Destroyable) {
            ++nifaces;
        }
        if (job instanceof ITimedJob) {
            ++nifaces;
            if (this.interceptNextExecutionDelay) {
                ++nintercepted;
            }
        }
        Class[] ifaces = new Class[nifaces];
        Class[] intercepted = new Class[nintercepted];
        nifaces = 0;
        nintercepted = 0;
        ifaces[nifaces++] = base;
        intercepted[nintercepted++] = base;
        if (job instanceof HasCallback) {
            ifaces[nifaces++] = HasCallback.class;
        }
        if (job instanceof Destroyable) {
            ifaces[nifaces++] = Destroyable.class;
        }
        if (job instanceof ITimedJob) {
            ifaces[nifaces++] = ITimedJob.class;
            if (this.interceptNextExecutionDelay) {
                intercepted[nintercepted++] = ITimedJob.class;
            }
        }
        return this.proxyFactory.getMultiTypedProxy(job, ifaces, intercepted);
    }

    @Override
    public UUID scheduleJob(Runnable runnable) {
        Runnable proxy = (Runnable)this.interceptJob(runnable, Runnable.class);
        return this.delegate.scheduleJob(proxy);
    }

    @Override
    public UUID scheduleJob(Joinpoint joinpoint) {
        Joinpoint proxy = (Joinpoint)this.interceptJob(joinpoint, Joinpoint.class);
        return this.delegate.scheduleJob(proxy);
    }

    @Override
    public <V> UUID scheduleJob(Callable<V> callable) {
        Callable proxy = (Callable)this.interceptJob(callable, Callable.class);
        return this.delegate.scheduleJob(proxy);
    }

    @Override
    public <V> void scheduleJob(UUID id, Callable<V> callable) {
        Callable proxy = (Callable)this.interceptJob(callable, Callable.class);
        this.delegate.scheduleJob(id, proxy);
    }

    @Override
    public List<UUID> getAllJobsIds() {
        return this.delegate.getAllJobsIds();
    }

    @Override
    public IJobStatus getJobStatus(UUID jobId) {
        return this.delegate.getJobStatus(jobId);
    }

    @Override
    public IJobStatus waitForFinish(UUID jobId) throws InterruptedException, ExecutionException {
        return this.delegate.waitForFinish(jobId);
    }

    @Override
    public IJobStatus waitForFinish(UUID jobId, long timeoutMillis) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.waitForFinish(jobId, timeoutMillis);
    }

    @Override
    public IJobStatus cancelJob(UUID jobId, boolean mayInterrupt) {
        return this.delegate.cancelJob(jobId, mayInterrupt);
    }

    @Override
    public IJobStatus purgeResult(UUID jobId) {
        return this.delegate.purgeResult(jobId);
    }

    public IOneTimeScheduler getDelegate() {
        return this.delegate;
    }

    public void setDelegate(IOneTimeScheduler delegate) {
        this.delegate = delegate;
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public boolean isInterceptNextExecutionDelay() {
        return this.interceptNextExecutionDelay;
    }

    public void setInterceptNextExecutionDelay(boolean interceptNextExecutionDelay) {
        this.interceptNextExecutionDelay = interceptNextExecutionDelay;
    }
}

