/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.functional;

import java.time.Duration;
import org.clazzes.util.sched.ITimedJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatingTimed
implements ITimedJob {
    private final Duration timeWaitNextCall;
    private boolean doImmediate;
    private static final Logger log = LoggerFactory.getLogger(RepeatingTimed.class);

    public RepeatingTimed(Duration timeWaitNextCall, boolean scheduleImmediate) {
        assert (timeWaitNextCall != null);
        this.timeWaitNextCall = timeWaitNextCall;
        this.doImmediate = scheduleImmediate;
    }

    @Override
    public Long getNextExecutionDelay() {
        if (this.doImmediate) {
            this.doImmediate = false;
            return 1L;
        }
        log.debug(String.valueOf(this) + ": scheduling the job to be started in " + this.timeWaitNextCall.getSeconds() + " seconds.");
        return this.timeWaitNextCall.toMillis();
    }

    public String toString() {
        return "Repeating every " + String.valueOf(this.timeWaitNextCall);
    }
}

