/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.functional;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.TimeZone;
import org.clazzes.util.sched.ITimedJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DailyTimed
implements ITimedJob {
    private static final long SCHEDULE_GRACE_MILLI = 1000L;
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("Europe/Vienna");
    private final LocalTime timeToCall;
    private static final Logger log = LoggerFactory.getLogger(DailyTimed.class);
    private final TimeZone timeZone;

    public DailyTimed(LocalTime timeToCall, TimeZone timeZone) {
        assert (timeToCall != null);
        this.timeZone = timeZone != null ? timeZone : DEFAULT_TIMEZONE;
        this.timeToCall = timeToCall;
    }

    @Override
    public Long getNextExecutionDelay() {
        Instant now = Instant.now();
        long nowMillis = now.toEpochMilli();
        LocalDate currentDate = now.atZone(this.timeZone.toZoneId()).toLocalDate();
        long timeToCallTodayMillis = this.timeToCall.atDate(currentDate).atZone(this.timeZone.toZoneId()).toInstant().toEpochMilli();
        if (timeToCallTodayMillis > nowMillis + 1000L) {
            long retValue = timeToCallTodayMillis - nowMillis;
            if (log.isDebugEnabled()) {
                String todayDt = this.timeToCall.atDate(currentDate).toString();
                log.debug(String.valueOf(this) + ": scheduling the job to be started today at '" + todayDt + "', now is '" + String.valueOf(now) + "'; returning [" + retValue + "]");
            }
            return retValue;
        }
        LocalDate tomorrowDate = currentDate.plusDays(1L);
        long timeToCallTomorrowMillis = this.timeToCall.atDate(tomorrowDate).atZone(this.timeZone.toZoneId()).toInstant().toEpochMilli();
        if (timeToCallTomorrowMillis < nowMillis) {
            String tomorrowDt = this.timeToCall.atDate(tomorrowDate).toString();
            throw new RuntimeException(String.valueOf(this) + ": startNextDay = '" + tomorrowDt + "' is expected to be after '" + String.valueOf(now) + "' but was not.");
        }
        long retValue = timeToCallTomorrowMillis - nowMillis;
        if (log.isDebugEnabled()) {
            String tomorrowDt = this.timeToCall.atDate(tomorrowDate).toString();
            log.debug(String.valueOf(this) + ": scheduling the job to be started tomorrow, at '" + tomorrowDt + "', now is '" + String.valueOf(now) + "'; returning [" + retValue + "]");
        }
        return retValue;
    }

    public String toString() {
        return "Daily at " + String.valueOf(this.timeToCall);
    }
}

