/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sched.cache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.clazzes.util.aop.IFileDeleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScratchFile
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ScratchFile.class);
    private final File file;
    private final String mimeType;
    private final String disposition;
    private IFileDeleter fileDeleter;
    private boolean closed;

    public ScratchFile(File file, String mimeType, String disposition) {
        this.file = file;
        this.mimeType = mimeType;
        this.disposition = disposition;
        this.closed = false;
    }

    public ScratchFile(IFileDeleter fileDeleter, File file, String mimeType, String disposition) {
        this.fileDeleter = fileDeleter;
        this.file = file;
        this.mimeType = mimeType;
        this.disposition = disposition;
        this.closed = false;
    }

    public File getFile() {
        return this.file;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void deleteAndClose() {
        if (!this.closed) {
            if (this.fileDeleter == null) {
                if (!this.file.delete()) {
                    log.warn("Cannot delete scratch file [{}].", (Object)this.file);
                }
            } else {
                this.fileDeleter.deleteFile(this.file);
                this.fileDeleter = null;
            }
            this.closed = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.deleteAndClose();
    }

    public void finalize() throws Throwable {
        this.deleteAndClose();
    }

    public String toString() {
        return "ScratchFile [file=" + String.valueOf(this.file) + ", mimeType=" + this.mimeType + ", disposition=" + this.disposition + "]";
    }
}

