/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 11.12.2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched.impl;

import java.util.Locale;

import org.clazzes.util.aop.i18n.Messages;
import org.clazzes.util.aop.i18n.MessagesFactory;

/**
 * A factory for sched-util i18n messages.
 */
public abstract class SchedUtilMessages {

    public static Messages getMessages(Locale locale) {
        return MessagesFactory.newMessages(locale,SchedUtilMessages.class);
    }
}
