/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 04.10.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched.impl;

import java.util.UUID;

import org.clazzes.util.sched.HasCallback;
import org.clazzes.util.sched.IJobStatusWithCallback;

/**
 * The implementation of a job status with a callback instance.
 */
class JobStatusWithCallbackImpl<C> extends JobStatusImpl implements
        IJobStatusWithCallback<C> {

    final C callback;
    final Class<C> callbackClass;
    
    public JobStatusWithCallbackImpl(HasCallback<C> carrier, UUID uuid) {
        
        super(uuid);
        this.callback = carrier.getCallback();
        this.callbackClass = carrier.getCallbackClass();
    }
    
    @Override
    public C getCallback() {
        
        return this.callback;
    }

    @Override
    public Class<C> getCallbackClass() {
        
        return this.callbackClass;
    }
    
}
