/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 29.11.2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched.impl;

import java.util.concurrent.Callable;

import org.clazzes.util.sched.HasCallback;
import org.clazzes.util.sched.api.ILoggingCallback;

/**
 * An abstract base class for callables, which provide logging
 * through {@link LoggingCallbackImpl}.
 */
public abstract class HasLoggingCallable<V> implements Callable<V>,
        HasCallback<ILoggingCallback> {

    private final ILoggingCallback callback;

    public HasLoggingCallable() {
        
        this.callback = new LoggingCallbackImpl();
    }
    
    public HasLoggingCallable(int maxCachedMessages) {
        
        this.callback = new LoggingCallbackImpl(maxCachedMessages);
    }

    public HasLoggingCallable(ILoggingCallback callback) {
        
        this.callback = callback;
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.sched.HasCallback#getCallback()
     */
    @Override
    public ILoggingCallback getCallback() {
        
        return this.callback;
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.sched.HasCallback#getCallbackClass()
     */
    @Override
    public Class<ILoggingCallback> getCallbackClass() {
        
        return ILoggingCallback.class;
    }

}
