/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 29.11.2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched.impl;

import org.clazzes.util.sched.HasCallback;

/**
 * Static helper functions for logging callbacks.
 */
public abstract class CallbackHelper {

    /**
     * 
     * @param jobOrStatus A job or status object possibly implementing
     *             {@link HasCallback}
     * @param type The type of the callback object to fetch.
     * @return The callback of type <code>T</code> or <code>null</code>,
     *         if <code>jobOrStatus</code> does not implement
     *          {@link HasCallback} or the callback object is not
     *          assignable to <code>type</code>.
     */
    static public <T> T getCallbackOfType(Object jobOrStatus,Class<T> type) {
        
        if (jobOrStatus instanceof HasCallback &&                 
                type.isAssignableFrom(((HasCallback<?>)jobOrStatus).getCallbackClass())) {
            
            @SuppressWarnings("unchecked")
            HasCallback<T> swcb = (HasCallback<T>) jobOrStatus;

           return swcb.getCallback();
        }
        else {
            return null;
        }
    }
}
