package org.clazzes.util.sched.functional;

import org.clazzes.util.sched.ITimedJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.Duration;

/**
 * Repeats the call of the delegate Callable after duration to be used with the "oneTimeScheduler".
 * You can start an immediate first execution.
 */
public class RepeatingTimed implements ITimedJob {

    private final Duration timeWaitNextCall;

    private boolean doImmediate;

    private static final Logger log = LoggerFactory.getLogger(RepeatingTimed.class);

    public RepeatingTimed(Duration timeWaitNextCall, boolean scheduleImmediate) {
        assert timeWaitNextCall != null;
        this.timeWaitNextCall = timeWaitNextCall;
        this.doImmediate = scheduleImmediate;
    }

    public Long getNextExecutionDelay() {
        // Return value given in ms

        // schedule once immediately and then repeat normally
        if (this.doImmediate) {
            this.doImmediate = false;
            return 1L;
        }

        log.debug(this + ": scheduling the job to be started in "
                + this.timeWaitNextCall.getSeconds() + " seconds."); // JDK 8 does not have "toSeconds"

        return this.timeWaitNextCall.toMillis();
    }

    @Override
    public String toString() {
        return "Repeating every " + timeWaitNextCall;
    }
}
