/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 16.02.2016
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched.cache;

import java.io.Closeable;
import java.io.File;

/**
 * A bucket in a scratch file cache used to fetch temporary files
 * by a key or to add a temporary file later on.
 * 
 * If two buckets are concurrently allocated in the same cache,
 * one thread waits for the other to provide the given resource.
 */
public interface IScratchBucket extends Closeable {

    /**
     * @return The application-specific key of the given scratch
     *         entry. 
     */
    public String getKey();
    
    /**
     * @return The cached scratch file, if this bucket has ready been
     *         filled with data.
     *         If <code>null</code> is returned, a new scratch file
     *         must be provided by the calling process.
     */
    public ScratchFile getScratchFile();
    
    /**
     * Create a new scratch file and provide it to other thread waiting for data
     * under the given key.
     * 
     * @param file The file to be provided.
     * @param mimeType The MIME type of the content
     * @param disposition The content-disposition a known from the likewise HTTP header.
     */
    public ScratchFile provideScratchFile(File file, String mimeType, String disposition);
}
