/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 28.11.2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched.api;

import java.util.List;

import org.clazzes.util.aop.ThreadLocalManager;

/**
 * A callback interface for getting feedback during long running
 * jobs.
 */
public interface ILoggingCallback {

    /**
     * The key under which a logging callback is bound to the local thread using
     * {@link ThreadLocalManager#bindResource(String, Object)}.
     */
    public static final String THREAD_LOCAL_KEY = "org.clazzes.util.sched::ILoggingCallback";
    
    /**
     * @param msg An OK confirmation message for display on the client.
     */
    public void ok(String msg);
    /**
     * @param msg A debug message for display on the client.
     */
    public void debug(String msg);
	/**
	 * @param msg An informational message for display on the client.
	 */
	public void info(String msg);
	/**
	 * @param msg A warning message for display on the client.
	 */
	public void warning(String msg);
	/**
	 * @param msg An error message for display on the client.
	 */
	public void error(String msg);
	
    /**
     * @return The list of log message accumulated since the last call
     *         to this function.
     */
    public List<LogMessage> getLastLogMessages();
}
