/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 28.11.2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched.api;

import java.util.UUID;

/**
 * A service for querying the status of long-running jobs.
 */
public interface IJobStatusService {

	/**
	 * @param jobId The ID of a long running-job, which is returned
	 *              as result of a POST request in the form
	 *              <code>JOB_UUID=&lt;jobId&gt;</code>
	 * @return The status, if the job is known. If <code>null</code>
	 *         is returned, the job is not known, or the status
	 *         of the job has expired.
	 */
	public JobStatusDTO getJobStatus(UUID jobId);
	
    /**
     * @param jobId The ID of a long running-job, which is returned
     *              as result of a POST request in the form
     *              <code>JOB_UUID=&lt;jobId&gt;</code>
     * @param timeout The number of milliseconds to wait for the termination of the job.
     * @return The status, if the job is known. If <code>null</code>
     *         is returned, the job is not known, or the status
     *         of the job has expired.
     */
    public JobStatusDTO waitForJob(UUID jobId, long timeout);

    /**
	 * Cancel the job with the given ID.
	 * 
	 * @param jobId The ID of a long running-job, which is returned
	 *          as result of a POST request in the form
	 *          <code>JOB_UUID=&lt;jobId&gt;</code>
	 * @return The status, if the job is known. If <code>null</code>
	 *         is returned, the job is not known, or the status
	 *         of the job has expired.
	 */
	public JobStatusDTO cancelJob(UUID jobId);
}
