/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 04.06.2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;

import org.aopalliance.intercept.Joinpoint;
import org.aopalliance.intercept.MethodInvocation;

/**
 * A callable, which is an adapter for a {@link Joinpoint}.
 * This allows to schedule a {@link MethodInvocation} to
 * a {@link IOneTimeScheduler} instance.
 */
public class JoinpointCallableAdapter implements Callable<Object> {

    private final Joinpoint joinpoint;
    
    public JoinpointCallableAdapter(Joinpoint joinpoint) {
        super();
        this.joinpoint = joinpoint;
    }

    /* (non-Javadoc)
     * @see java.util.concurrent.Callable#call()
     */
    @Override
    public Object call() throws Exception {
        
        try {
            return this.joinpoint.proceed();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e,"Error calling joinpoint from callable adapter");
        }
    }

    /**
     * @return The joinpoint backed by this callable.
     */
    public Joinpoint getJoinpoint() {
        return this.joinpoint;
    }

}
