/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 27.05.2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched;

/** A job that supports specifying when it wants to be executed next time.
 */
public interface ITimedJob {

    /** Returns the delay, given in ms, relative to the current system time, 
     *  after which the job wants to get executed next time, or null if no such
     *  execution is wanted.
     *  
     *  This function is executed in two cases:  On the one hand, in the
     *  startup code executed right after the corresponding Runnable is
     *  passed to the scheduler; and on the other hand right after the job
     *  has completed.
     *  
     *  Thus, the interval is relative to the last completion of the job,
     *  and not meant to be a fixed interval in the sense "Execute at
     *  t = 1 * interval, t = 2 * interval, t = 3 * interval, ...".
     * 
     * @return delay, given in ms, relative to the current system time, 
     *         after which the job wants to get executed next time; 
     *         null if and only if the job does not want another execution
     */
	Long getNextExecutionDelay();
}
