/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 04.10.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched;

/**
 * A status for an individual job.
 */
public interface IJobStatus {

    /**
     * @return whether this job was cancelled before it completed
     * normally.
     */
    public boolean isCancelled();
    
    /** 
     * @return Returns whether this job has already completed ---
     *    either due to normal termination, an exception
     *     or cancellation.
     *  In the rare circumstance, that an {@link ITimedJob} has been
     *  never been started, this method return <code>true</code> and
     *  {@link #getFinishedMillis()} returns <code>-1</code>.
     */
    public boolean isDone();
    
    /** 
     * @return the result of the job, after it has completed.  If it has not yet terminated,
     *  or terminated with an exception, or terminated without result, null is returned. 
     */
    public Object getResult();
    
    /**
     *  @return the exception, if the job has terminated with an exception.  Returns null if
     *  the job runs, or completed without exception.
     */
    public Throwable getException();
    
    /** 
     * @return when the job has finished, or <code>-1</code> if it has not yet finished.
     *         In the rare circumstance, that an {@link ITimedJob} has
     *         never been started, this method return <code>-1</code> and
     *         {@link #isDone()} returns <code>true</code>.
     */
    public long getFinishedMillis();
    
    /**
     * @return The next intended execution since {@link #getFinishedMillis()}
     *         in milliseconds.
     *         If <code>null</code>, this is a one-time job or a timed job,
     *         which is finished and will not be executed again.
     *         If {@link #isDone()} returns <code>false</code>, this was the
     *         intended next execution since the last execution.
     */
    public Long getNextExecutionDelay();

}
