/***********************************************************
 * $Id$
 * 
 * scheduler utilities of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 04.10.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sched;

/**
 * Jobs implementing this interface provide an application-specific
 * callback object, on which the job might give back information
 * to the caller.
 */
public interface HasCallback<C> {

    /**
     * @return The callback object, which will be provided to users of the scheduler
     *         via {@link IJobStatusWithCallback}.
     */
    C getCallback();
    
    /**
     * @return The class object of the callback interface, which allows to query
     *         the callback interface at runtime.
     */
    Class<C> getCallbackClass();
}
