/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

public class ModuleLSInput
implements LSInput {
    private static final Logger log = LoggerFactory.getLogger(ModuleLSInput.class);
    private final String resourcePath;
    private final Module module;
    private String baseURI;
    private String publicId;
    private String systemId;
    private boolean certifiedText;

    public ModuleLSInput(Module module, String resourcePath, String publicId, String systemId, String baseURI, boolean certifiedText) {
        this.resourcePath = resourcePath;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.certifiedText = certifiedText;
        this.module = module;
    }

    public ModuleLSInput(Module module, String resourcePath, String publicId, String systemId, String baseURI) {
        this.resourcePath = resourcePath;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.certifiedText = true;
        this.module = module;
    }

    public ModuleLSInput(String resourcePath, String publicId, String systemId, String baseURI, boolean certifiedText) {
        this.resourcePath = resourcePath;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.certifiedText = certifiedText;
        this.module = ModuleLSInput.class.getModule();
    }

    public ModuleLSInput(String resourcePath, String publicId, String systemId, String baseURI) {
        this.resourcePath = resourcePath;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.certifiedText = true;
        this.module = ModuleLSInput.class.getModule();
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public InputStream getByteStream() {
        InputStream is;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Loading resource [{}] from module [{}].", (Object)this.resourcePath, (Object)this.module);
            }
            is = this.module.getResourceAsStream(this.resourcePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to load resource [" + this.resourcePath + "] from module [" + String.valueOf(this.module) + "]", e);
        }
        if (is == null) {
            log.warn("Cannot find resource [{}] in module [{}].", (Object)this.resourcePath, (Object)this.module);
        }
        return is;
    }

    @Override
    public boolean getCertifiedText() {
        return this.certifiedText;
    }

    @Override
    public Reader getCharacterStream() {
        return null;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getStringData() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public void setByteStream(InputStream byteStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCertifiedText(boolean certifiedText) {
        this.certifiedText = certifiedText;
    }

    @Override
    public void setCharacterStream(Reader characterStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    @Override
    public void setStringData(String stringData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

