/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.clazzes.util.sec.PlainPasswordHasher;

public class SSHA1PasswordHasher
extends PlainPasswordHasher {
    private Base64 base64encoder = new Base64();

    @Override
    public String hashPassword(String cleartext, String salt) {
        return this.algo_prefix + this.sha1(cleartext, salt);
    }

    @Override
    public boolean checkPassword(String cleartext, String hashed) {
        int l;
        String hash_salt = this.stripAlgorithmKey((String)hashed);
        String salt = hash_salt.substring((l = hash_salt.length()) - 4);
        String rehashed = this.hashPassword(cleartext, salt);
        if (rehashed.equals(hashed)) {
            return true;
        }
        if (((String)hashed).length() == rehashed.length() + 4 && hash_salt.charAt(l - 8) == salt.charAt(0) && hash_salt.charAt(l - 7) == salt.charAt(1) && hash_salt.charAt(l - 6) == salt.charAt(2) && hash_salt.charAt(l - 5) == salt.charAt(3)) {
            hashed = ((String)hashed).substring(0, ((String)hashed).length() - 4);
            return rehashed.equals(hashed);
        }
        if (((String)hashed).length() == rehashed.length() + 6 && hash_salt.charAt(l - 10) == '\r' & hash_salt.charAt(l - 9) == '\n' && hash_salt.charAt(l - 8) == salt.charAt(0) && hash_salt.charAt(l - 7) == salt.charAt(1) && hash_salt.charAt(l - 6) == salt.charAt(2) && hash_salt.charAt(l - 5) == salt.charAt(3)) {
            hashed = ((String)hashed).substring(0, ((String)hashed).length() - 10) + salt;
            return rehashed.equals(hashed);
        }
        return false;
    }

    @Override
    public String getAlgorithmName() {
        return "SSHA1";
    }

    private String sha1(String cleartext, String salt) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            osw.write(cleartext);
            osw.write(salt);
            osw.close();
            baos.close();
            MessageDigest sha1digest = MessageDigest.getInstance("SHA-1");
            sha1digest.update(baos.toByteArray());
            byte[] sha1ba = sha1digest.digest();
            String s = this.base64encoder.encodeToString(sha1ba);
            return s.trim() + salt;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getSaltLength() {
        return 4;
    }
}

