/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sec;

import org.apache.commons.codec.digest.Crypt;
import org.clazzes.util.sec.HashTools;
import org.clazzes.util.sec.PlainPasswordHasher;

public class CryptPasswordHasher
extends PlainPasswordHasher {
    private final Variant variant;

    public CryptPasswordHasher(Variant variant) {
        this.variant = variant;
    }

    public CryptPasswordHasher() {
        this(Variant.SHA512);
    }

    @Override
    public String hashPassword(String cleartext, String salt) {
        return this.algo_prefix + Crypt.crypt((String)cleartext, (String)salt);
    }

    @Override
    public boolean checkPassword(String cleartext, String hashed) {
        String salt;
        String hash_salt = this.stripAlgorithmKey(hashed);
        if (hash_salt.startsWith("$5$") || hash_salt.startsWith("$6$")) {
            int endSalt = hash_salt.indexOf(36, 3);
            if (endSalt < 0) {
                throw new IllegalArgumentException("Crypt hash with SHA256 or SHA512 scheme does not contain a third dollar sign.");
            }
            salt = hash_salt.substring(0, endSalt);
        } else {
            salt = hash_salt.substring(0, 2);
        }
        String rehashed = this.hashPassword(cleartext, salt);
        return rehashed.equals(hashed);
    }

    @Override
    public String getAlgorithmName() {
        return "CRYPT";
    }

    @Override
    public String hashPassword(String cleartext) {
        Object salt;
        if (this.variant == Variant.CRYPT) {
            salt = HashTools.randomSalt(2);
        } else {
            String pfx = this.variant == Variant.SHA256 ? "$5$" : "$6$";
            salt = pfx + HashTools.randomSalt(19);
        }
        return this.hashPassword(cleartext, (String)salt);
    }

    @Override
    public int getSaltLength() {
        return this.variant == Variant.CRYPT ? 2 : 19;
    }

    public static enum Variant {
        CRYPT,
        SHA256,
        SHA512;

    }
}

