/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.ryu;

import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import org.clazzes.util.ryu.RoundingMode;
import org.clazzes.util.ryu.RyuDouble;
import org.clazzes.util.ryu.RyuFloat;

public class RyuNumberFormat
extends Format {
    private static final long serialVersionUID = -1854037583417190194L;
    private final DecimalFormatSymbols symbols;
    private final RoundingMode roundingMode;
    private final int options;

    public RyuNumberFormat(DecimalFormatSymbols symbols, RoundingMode roundingMode, int options) {
        this.symbols = symbols;
        this.roundingMode = roundingMode;
        this.options = options;
    }

    public RyuNumberFormat(DecimalFormatSymbols symbols, int options) {
        this(symbols, RoundingMode.ROUND_EVEN, options);
    }

    public RyuNumberFormat(DecimalFormatSymbols symbols) {
        this(symbols, RoundingMode.ROUND_EVEN, 0);
    }

    public RyuNumberFormat(Locale locale) {
        this(DecimalFormatSymbols.getInstance(locale));
    }

    public RyuNumberFormat(Locale locale, int options) {
        this(DecimalFormatSymbols.getInstance(locale), RoundingMode.ROUND_EVEN, options);
    }

    public RyuNumberFormat(Locale locale, RoundingMode roundingMode, int options) {
        this(DecimalFormatSymbols.getInstance(locale), roundingMode, options);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Number n = (Number)obj;
        if (n instanceof Float) {
            RyuFloat.floatToString(toAppendTo, n.floatValue(), this.symbols, this.roundingMode, this.options);
        } else {
            RyuDouble.doubleToString(toAppendTo, n.doubleValue(), this.symbols, this.roundingMode, this.options);
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }
}

