/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.ryu;

import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Objects;
import org.clazzes.util.lang.Util;
import org.clazzes.util.ryu.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RyuDouble {
    private static final Logger log = LoggerFactory.getLogger(RyuDouble.class);
    private static final int DOUBLE_MANTISSA_BITS = 52;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int DOUBLE_EXPONENT_BITS = 11;
    private static final int DOUBLE_EXPONENT_MASK = 2047;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final int POS_TABLE_SIZE = 326;
    private static final int NEG_TABLE_SIZE = 291;
    private static final BigInteger[] POW5 = new BigInteger[326];
    private static final BigInteger[] POW5_INV = new BigInteger[291];
    private static final int POW5_BITCOUNT = 121;
    private static final int POW5_QUARTER_BITCOUNT = 31;
    private static final int[][] POW5_SPLIT = new int[326][4];
    private static final int POW5_INV_BITCOUNT = 122;
    private static final int POW5_INV_QUARTER_BITCOUNT = 31;
    private static final int[][] POW5_INV_SPLIT = new int[291][4];

    public static DecimalMantExp extractDecimalMantExp(double value, RoundingMode roundingMode) {
        long output;
        int e10;
        long dm;
        long dp;
        long dv;
        boolean sign;
        long m2;
        int e2;
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Argument was NaN or Infinity.");
        }
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L) {
            return new DecimalMantExp(false, 0L, 0);
        }
        if (bits == Long.MIN_VALUE) {
            return new DecimalMantExp(true, 0L, 0);
        }
        int ieeeExponent = (int)(bits >>> 52 & 0x7FFL);
        long ieeeMantissa = bits & 0xFFFFFFFFFFFFFL;
        if (ieeeExponent == 0) {
            e2 = -1074;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 1023 - 52;
            m2 = ieeeMantissa | 0x10000000000000L;
        }
        boolean bl = sign = bits < 0L;
        if (log.isDebugEnabled()) {
            log.debug("IN=" + Long.toBinaryString(bits));
            log.debug("   S=" + (sign ? "-" : "+") + " E=" + e2 + " M=" + m2);
        }
        boolean even = (m2 & 1L) == 0L;
        long mv = 4L * m2;
        long mp = 4L * m2 + 2L;
        int mmShift = m2 != 0x10000000000000L || ieeeExponent <= 1 ? 1 : 0;
        long mm = 4L * m2 - 1L - (long)mmShift;
        e2 -= 2;
        if (log.isDebugEnabled()) {
            String sm;
            String sp;
            String sv;
            if (e2 >= 0) {
                sv = BigInteger.valueOf(mv).shiftLeft(e2).toString();
                sp = BigInteger.valueOf(mp).shiftLeft(e2).toString();
                sm = BigInteger.valueOf(mm).shiftLeft(e2).toString();
                e10 = 0;
            } else {
                BigInteger factor = BigInteger.valueOf(5L).pow(-e2);
                sv = BigInteger.valueOf(mv).multiply(factor).toString();
                sp = BigInteger.valueOf(mp).multiply(factor).toString();
                sm = BigInteger.valueOf(mm).multiply(factor).toString();
                e10 = e2;
            }
            log.debug("E =" + (e10 += sp.length() - 1));
            log.debug("d+=" + sp);
            log.debug("d =" + sv);
            log.debug("d-=" + sm);
            log.debug("e2=" + e2);
        }
        boolean dmIsTrailingZeros = false;
        boolean dvIsTrailingZeros = false;
        if (e2 >= 0) {
            q = Math.max(0, (e2 * 78913 >>> 18) - 1);
            int k = 122 + RyuDouble.pow5bits(q) - 1;
            int i = -e2 + q + k;
            dv = RyuDouble.mulPow5InvDivPow2(mv, q, i);
            dp = RyuDouble.mulPow5InvDivPow2(mp, q, i);
            dm = RyuDouble.mulPow5InvDivPow2(mm, q, i);
            e10 = q;
            if (log.isDebugEnabled()) {
                log.debug(mv + " * 2^" + e2);
                log.debug("V+=" + dp);
                log.debug("V =" + dv);
                log.debug("V-=" + dm);
            }
            if (log.isDebugEnabled()) {
                long exact = POW5_INV[q].multiply(BigInteger.valueOf(mv)).shiftRight(-e2 + q + k).longValueExact();
                log.debug(exact + " " + POW5_INV[q].bitCount());
                if (dv != exact) {
                    throw new IllegalStateException();
                }
            }
            if (q <= 21) {
                if (mv % 5L == 0L) {
                    dvIsTrailingZeros = RyuDouble.multipleOfPowerOf5(mv, q);
                } else if (roundingMode.acceptUpperBound(even)) {
                    dmIsTrailingZeros = RyuDouble.multipleOfPowerOf5(mm, q);
                } else if (RyuDouble.multipleOfPowerOf5(mp, q)) {
                    --dp;
                }
            }
        } else {
            q = Math.max(0, (-e2 * 732923 >>> 20) - 1);
            int i = -e2 - q;
            int k = RyuDouble.pow5bits(i) - 121;
            int j = q - k;
            dv = RyuDouble.mulPow5divPow2(mv, i, j);
            dp = RyuDouble.mulPow5divPow2(mp, i, j);
            dm = RyuDouble.mulPow5divPow2(mm, i, j);
            e10 = q + e2;
            if (log.isDebugEnabled()) {
                log.debug(mv + " * 5^" + -e2 + " / 10^" + q);
            }
            if (q <= 1) {
                dvIsTrailingZeros = true;
                if (roundingMode.acceptUpperBound(even)) {
                    dmIsTrailingZeros = mmShift == 1;
                } else {
                    --dp;
                }
            } else if (q < 63) {
                boolean bl2 = dvIsTrailingZeros = (mv & (1L << q - 1) - 1L) == 0L;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("d+=" + dp);
            log.debug("d =" + dv);
            log.debug("d-=" + dm);
            log.debug("e10=" + e10);
            log.debug("d-10=" + dmIsTrailingZeros);
            log.debug("d   =" + dvIsTrailingZeros);
            log.debug("Accept upper=" + roundingMode.acceptUpperBound(even));
            log.debug("Accept lower=" + roundingMode.acceptLowerBound(even));
        }
        int vplength = Util.decimalLength(dp);
        int exp = e10 + vplength - 1;
        int lastRemovedDigit = 0;
        if (dmIsTrailingZeros || dvIsTrailingZeros) {
            while (dp / 10L > dm / 10L) {
                dmIsTrailingZeros &= dm % 10L == 0L;
                dvIsTrailingZeros &= lastRemovedDigit == 0;
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
            }
            if (dmIsTrailingZeros && roundingMode.acceptLowerBound(even)) {
                while (dm % 10L == 0L) {
                    dvIsTrailingZeros &= lastRemovedDigit == 0;
                    lastRemovedDigit = (int)(dv % 10L);
                    dp /= 10L;
                    dv /= 10L;
                    dm /= 10L;
                }
            }
            if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2L == 0L) {
                lastRemovedDigit = 4;
            }
            output = dv + (long)(dv == dm && (!dmIsTrailingZeros || !roundingMode.acceptLowerBound(even)) || lastRemovedDigit >= 5 ? 1 : 0);
        } else {
            while (dp / 10L > dm / 10L) {
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
            }
            output = dv + (long)(dv == dm || lastRemovedDigit >= 5 ? 1 : 0);
        }
        if (log.isDebugEnabled()) {
            log.debug("LAST_REMOVED_DIGIT=" + lastRemovedDigit);
            log.debug("VP=" + dp);
            log.debug("VR=" + dv);
            log.debug("VM=" + dm);
            log.debug("O=" + output);
            log.debug("EXP=" + exp);
        }
        return new DecimalMantExp(sign, output, exp);
    }

    public static void doubleToString(StringBuffer sb, double value, DecimalFormatSymbols syms, RoundingMode roundingMode, int options) {
        if (Double.isNaN(value)) {
            sb.append(syms.getNaN());
            return;
        }
        if (value == Double.POSITIVE_INFINITY) {
            sb.append(syms.getInfinity());
            return;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            sb.append(syms.getMinusSign());
            sb.append(syms.getInfinity());
            return;
        }
        boolean showDotZero = (options & 1) != 0;
        boolean forceScientific = (options & 2) != 0;
        DecimalMantExp decMantExpr = RyuDouble.extractDecimalMantExp(value, roundingMode);
        boolean sign = decMantExpr.sign;
        long output = decMantExpr.mantissa;
        int exp = decMantExpr.exponent;
        if (output == 0L && exp == 0) {
            if (sign) {
                sb.append(syms.getMinusSign());
            }
            sb.append('0');
            if (showDotZero) {
                sb.append(syms.getDecimalSeparator());
                sb.append('0');
            }
            if (forceScientific) {
                sb.append(syms.getExponentSeparator());
                sb.append('0');
            }
            return;
        }
        boolean scientificNotation = forceScientific || exp < -3 || exp >= 7;
        int olength = Util.decimalLength(output);
        char[] result = new char[24];
        int index = 0;
        if (value < 0.0) {
            result[index++] = syms.getMinusSign();
        }
        if (scientificNotation) {
            for (int i = 0; i < olength - 1; ++i) {
                int c = (int)(output % 10L);
                output /= 10L;
                result[index + olength - i] = (char)(48 + c);
            }
            result[index] = (char)(48L + output % 10L);
            if (showDotZero || olength > 1) {
                result[index + 1] = syms.getDecimalSeparator();
                index += olength + 1;
                if (olength == 1) {
                    result[index++] = 48;
                }
            } else {
                index += olength;
            }
            sb.append(result, 0, index);
            index = 0;
            sb.append(syms.getExponentSeparator());
            if (exp < 0) {
                sb.append(syms.getMinusSign());
                exp = -exp;
            }
            if (exp >= 100) {
                result[index++] = (char)(48 + exp / 100);
                result[index++] = (char)(48 + (exp %= 100) / 10);
            } else if (exp >= 10) {
                result[index++] = (char)(48 + exp / 10);
            }
            result[index++] = (char)(48 + exp % 10);
        } else if (exp < 0) {
            result[index++] = 48;
            result[index++] = syms.getDecimalSeparator();
            for (int i = -1; i > exp; --i) {
                result[index++] = 48;
            }
            int current = index;
            for (int i = 0; i < olength; ++i) {
                result[current + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i;
            for (i = 0; i < olength; ++i) {
                result[index + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
            }
            index += olength;
            for (i = olength; i < exp + 1; ++i) {
                result[index++] = 48;
            }
            if (showDotZero) {
                result[index++] = syms.getDecimalSeparator();
                result[index++] = 48;
            }
        } else {
            int current = index + 1;
            for (int i = 0; i < olength; ++i) {
                if (olength - i - 1 == exp) {
                    result[current + olength - i - 1] = syms.getDecimalSeparator();
                    --current;
                }
                result[current + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
            }
            index += olength + 1;
        }
        sb.append(result, 0, index);
    }

    private static int pow5bits(int e) {
        return (e * 1217359 >>> 19) + 1;
    }

    private static boolean multipleOfPowerOf5(long value, int q) {
        return RyuDouble.pow5Factor(value) >= q;
    }

    private static int pow5Factor(long value) {
        if (value % 5L != 0L) {
            return 0;
        }
        if (value % 25L != 0L) {
            return 1;
        }
        if (value % 125L != 0L) {
            return 2;
        }
        if (value % 625L != 0L) {
            return 3;
        }
        int count = 4;
        value /= 625L;
        while (value > 0L) {
            if (value % 5L != 0L) {
                return count;
            }
            value /= 5L;
            ++count;
        }
        throw new IllegalArgumentException("" + value);
    }

    private static long mulPow5divPow2(long m, int i, int j) {
        long mHigh = m >>> 31;
        long mLow = m & Integer.MAX_VALUE;
        long bits13 = mHigh * (long)POW5_SPLIT[i][0];
        long bits03 = mLow * (long)POW5_SPLIT[i][0];
        long bits12 = mHigh * (long)POW5_SPLIT[i][1];
        long bits02 = mLow * (long)POW5_SPLIT[i][1];
        long bits11 = mHigh * (long)POW5_SPLIT[i][2];
        long bits01 = mLow * (long)POW5_SPLIT[i][2];
        long bits10 = mHigh * (long)POW5_SPLIT[i][3];
        long bits00 = mLow * (long)POW5_SPLIT[i][3];
        int actualShift = j - 93 - 21;
        if (actualShift < 0) {
            throw new IllegalArgumentException("" + actualShift);
        }
        return ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
    }

    private static long mulPow5InvDivPow2(long m, int i, int j) {
        long mHigh = m >>> 31;
        long mLow = m & Integer.MAX_VALUE;
        long bits13 = mHigh * (long)POW5_INV_SPLIT[i][0];
        long bits03 = mLow * (long)POW5_INV_SPLIT[i][0];
        long bits12 = mHigh * (long)POW5_INV_SPLIT[i][1];
        long bits02 = mLow * (long)POW5_INV_SPLIT[i][1];
        long bits11 = mHigh * (long)POW5_INV_SPLIT[i][2];
        long bits01 = mLow * (long)POW5_INV_SPLIT[i][2];
        long bits10 = mHigh * (long)POW5_INV_SPLIT[i][3];
        long bits00 = mLow * (long)POW5_INV_SPLIT[i][3];
        int actualShift = j - 93 - 21;
        if (actualShift < 0) {
            throw new IllegalArgumentException("" + actualShift);
        }
        return ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
    }

    static {
        BigInteger mask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        BigInteger invMask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        for (int i = 0; i < Math.max(POW5.length, POW5_INV.length); ++i) {
            BigInteger inv;
            int j;
            BigInteger pow = BigInteger.valueOf(5L).pow(i);
            int pow5len = pow.bitLength();
            int expectedPow5Bits = RyuDouble.pow5bits(i);
            if (expectedPow5Bits != pow5len) {
                throw new IllegalStateException(pow5len + " != " + expectedPow5Bits);
            }
            if (i < POW5.length) {
                RyuDouble.POW5[i] = pow;
            }
            if (i < POW5_SPLIT.length) {
                for (j = 0; j < 4; ++j) {
                    RyuDouble.POW5_SPLIT[i][j] = pow.shiftRight(pow5len - 121 + (3 - j) * 31).and(mask).intValueExact();
                }
            }
            if (i >= POW5_INV_SPLIT.length) continue;
            j = pow5len - 1 + 122;
            RyuDouble.POW5_INV[i] = inv = BigInteger.ONE.shiftLeft(j).divide(pow).add(BigInteger.ONE);
            for (int k = 0; k < 4; ++k) {
                RyuDouble.POW5_INV_SPLIT[i][k] = k == 0 ? inv.shiftRight((3 - k) * 31).intValueExact() : inv.shiftRight((3 - k) * 31).and(invMask).intValueExact();
            }
        }
    }

    public static class DecimalMantExp {
        public final boolean sign;
        public final long mantissa;
        public final int exponent;

        public DecimalMantExp(boolean sign, long mantissa, int exponent) {
            this.sign = sign;
            this.mantissa = mantissa;
            this.exponent = exponent;
        }

        public int hashCode() {
            return Objects.hash(this.exponent, this.mantissa, this.sign);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DecimalMantExp other = (DecimalMantExp)obj;
            return this.exponent == other.exponent && this.mantissa == other.mantissa && this.sign == other.sign;
        }

        public String toString() {
            return "DecimalMantExp [sign=" + this.sign + ", mantissa=" + this.mantissa + ", exponent=" + this.exponent + "]";
        }
    }
}

