/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.reflect;

public class PropertyHelper {
    private PropertyHelper() {
    }

    public static String getGetterName(String property) {
        return "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    public static String getSetterName(String property) {
        return "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    public static String getBooleanGetterName(String property) {
        return "is" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    private static String extractProperty(String pfx, String methodName) {
        if (methodName == null || methodName.length() < pfx.length() + 1 || !methodName.startsWith(pfx) || !Character.isUpperCase(methodName.charAt(pfx.length()))) {
            return null;
        }
        if (methodName.length() < pfx.length() + 2 || Character.isLowerCase(methodName.charAt(pfx.length() + 1))) {
            return Character.toLowerCase(methodName.charAt(pfx.length())) + methodName.substring(pfx.length() + 1);
        }
        return methodName.substring(pfx.length());
    }

    public static String getPropertyFromGetterName(String getterName) {
        return PropertyHelper.extractProperty("get", getterName);
    }

    public static String getBooleanPropertyFromGetterName(String getterName) {
        return PropertyHelper.extractProperty("is", getterName);
    }

    public static String getPropertyFromSetterName(String setterName) {
        return PropertyHelper.extractProperty("set", setterName);
    }
}

