/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import org.clazzes.util.reflect.FieldAccessor;
import org.clazzes.util.reflect.PropertyHelper;

public class POJOFieldAccessor
implements FieldAccessor {
    private Field field;
    private Method fieldGetter;
    private Method fieldSetter;
    private String fieldName;
    private FieldAccessor idAccesor;

    public POJOFieldAccessor(Field field) {
        this.field = field;
        String getterName = field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class) ? PropertyHelper.getBooleanGetterName(field.getName()) : PropertyHelper.getGetterName(field.getName());
        this.fieldGetter = this.getFieldGetter(getterName);
        String setterName = PropertyHelper.getSetterName(field.getName());
        try {
            this.fieldSetter = field.getDeclaringClass().getMethod(setterName, field.getType());
            if (Modifier.isStatic(this.fieldSetter.getModifiers())) {
                this.fieldSetter = null;
            }
        }
        catch (SecurityException e) {
            this.fieldSetter = null;
        }
        catch (NoSuchMethodException e) {
            this.fieldSetter = null;
        }
        this.fieldName = this.field.getName();
    }

    private Method getFieldGetter(String getterName) {
        Method getter = null;
        try {
            getter = this.field.getDeclaringClass().getMethod(getterName, new Class[0]);
            if (Modifier.isStatic(getter.getModifiers())) {
                getter = null;
            }
        }
        catch (SecurityException e) {
            getter = null;
        }
        catch (NoSuchMethodException e) {
            if ((this.field.getType().equals(Boolean.TYPE) || this.field.getType().equals(Boolean.class)) && getterName.startsWith("is")) {
                return this.getFieldGetter(PropertyHelper.getGetterName(this.field.getName()));
            }
            getter = null;
        }
        return getter;
    }

    public POJOFieldAccessor(Class clazz, String property) throws NoSuchMethodException, SecurityException {
        this.field = null;
        String getterName = PropertyHelper.getGetterName(property);
        try {
            this.fieldGetter = clazz.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getterName = PropertyHelper.getBooleanGetterName(property);
            this.fieldGetter = clazz.getMethod(getterName, new Class[0]);
        }
        if (this.fieldGetter.getReturnType().equals(Boolean.TYPE)) {
            if (!getterName.startsWith("is")) {
                throw new NoSuchMethodException("Method [" + String.valueOf(this.fieldGetter) + "] has a boolean return value.");
            }
        } else if (!getterName.startsWith("get")) {
            throw new NoSuchMethodException("Method [" + String.valueOf(this.fieldGetter) + "] has a non-boolean return value.");
        }
        if (Modifier.isStatic(this.fieldGetter.getModifiers())) {
            throw new NoSuchMethodException("Method [" + String.valueOf(this.fieldGetter) + "] is a static function.");
        }
        String setterName = PropertyHelper.getSetterName(property);
        try {
            this.fieldSetter = this.fieldGetter.getDeclaringClass().getMethod(setterName, this.fieldGetter.getReturnType());
            if (Modifier.isStatic(this.fieldSetter.getModifiers())) {
                this.fieldSetter = null;
            }
        }
        catch (SecurityException e) {
            this.fieldSetter = null;
        }
        catch (NoSuchMethodException e) {
            this.fieldSetter = null;
        }
        this.fieldName = property;
    }

    public POJOFieldAccessor(Method getter) throws NoSuchMethodException {
        this.field = null;
        if (Modifier.isStatic(getter.getModifiers())) {
            throw new NoSuchMethodException("Method [" + String.valueOf(this.fieldGetter) + "] is a static function.");
        }
        Class<?> retType = getter.getReturnType();
        this.fieldName = retType.equals(Boolean.TYPE) ? PropertyHelper.getBooleanPropertyFromGetterName(getter.getName()) : PropertyHelper.getPropertyFromGetterName(getter.getName());
        if (this.fieldName == null && retType.equals(Boolean.class)) {
            this.fieldName = PropertyHelper.getBooleanPropertyFromGetterName(getter.getName());
        }
        if (this.fieldName == null) {
            throw new NoSuchMethodException("Method [" + String.valueOf(getter) + "] is not a valid getter.");
        }
        if (getter.getParameterTypes().length > 0) {
            throw new NoSuchMethodException("Method [" + String.valueOf(getter) + "] has one or more arguments.");
        }
        this.fieldGetter = getter;
        String setterName = PropertyHelper.getSetterName(this.fieldName);
        try {
            this.fieldSetter = this.fieldGetter.getDeclaringClass().getMethod(setterName, this.fieldGetter.getReturnType());
            if (Modifier.isStatic(this.fieldSetter.getModifiers())) {
                this.fieldSetter = null;
            }
        }
        catch (SecurityException e) {
            this.fieldSetter = null;
        }
        catch (NoSuchMethodException e) {
            this.fieldSetter = null;
        }
    }

    @Override
    public Object getValueOf(Object pojo) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.fieldGetter != null) {
            return this.fieldGetter.invoke(pojo, new Object[0]);
        }
        return this.field.get(pojo);
    }

    @Override
    public void setValueOn(Object pojo, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.fieldSetter != null) {
            this.fieldSetter.invoke(pojo, value);
        } else if (this.field != null) {
            this.field.set(pojo, value);
        } else {
            throw new IllegalAccessException("No setter for field [" + this.fieldName + "] has been found.");
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        T ann = null;
        if (this.field != null) {
            ann = this.field.getAnnotation(type);
        }
        if (ann == null && this.fieldGetter != null) {
            ann = this.fieldGetter.getAnnotation(type);
        }
        return ann;
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.field != null) {
            return this.field.getAnnotations();
        }
        return this.fieldGetter.getAnnotations();
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public Class getType() {
        if (this.field != null) {
            return this.field.getType();
        }
        return this.fieldGetter.getReturnType();
    }

    @Override
    public Class getDeclaringClass() {
        if (this.field != null) {
            return this.field.getDeclaringClass();
        }
        return this.fieldGetter.getDeclaringClass();
    }

    @Override
    public boolean checkMandatory() {
        if (this.getType().isPrimitive()) {
            return true;
        }
        Column colAnn = this.getColumnAnnotation();
        if (colAnn != null) {
            return !colAnn.nullable();
        }
        return false;
    }

    @Override
    public boolean checkUpdatable() {
        Column colAnn = this.getColumnAnnotation();
        if (colAnn != null) {
            return colAnn.updatable();
        }
        return true;
    }

    @Override
    public void setIdAccessor(FieldAccessor idAccessor) {
        this.idAccesor = idAccessor;
    }

    @Override
    public FieldAccessor getIdAccessor() {
        return this.idAccesor;
    }

    private Column getColumnAnnotation() {
        AttributeOverride attributeOverride;
        Column colAnn = this.getAnnotation(Column.class);
        if (colAnn != null) {
            return colAnn;
        }
        AttributeOverrides attributeOverrides = this.getAnnotation(AttributeOverrides.class);
        if (attributeOverrides != null && ((AttributeOverride[])(attributeOverride = attributeOverrides.value())).length > 0 && (colAnn = attributeOverride[0].column()) != null) {
            return colAnn;
        }
        attributeOverride = this.getAnnotation(AttributeOverride.class);
        if (attributeOverride != null && (colAnn = attributeOverride.column()) != null) {
            return colAnn;
        }
        return null;
    }
}

