/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.lang;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.zip.CRC32;
import org.clazzes.util.sec.HashTools;

public class Util {
    public static final String CHARSET_ASCII = "US-ASCII";
    public static final String CHARSET_ISO88591 = "ISO-8859-1";
    public static final String CHARSET_UTF8 = "UTF-8";
    private static OperatingSystem operating_system = OperatingSystem.UNKOWN;
    private static final int[] DECIMAL_DIGITS_GUESS = new int[]{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 17, 17, 17, 18, 18, 18, 18, 19};
    private static final int[] TEN_TO_THE_INTS = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final long[] TEN_TO_THE_LONGS = new long[]{0L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    private Util() {
    }

    public static boolean equalsNullAware(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static int compareNullAware(Comparable a, Comparable b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static int getCRC32(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return (int)crc.getValue();
    }

    public static byte[] fillUp(byte[] src, int length, byte fillWith) {
        int rest = src.length % length;
        if (rest == 0) {
            return src;
        }
        int newLength = src.length + length - rest;
        byte[] newSrc = new byte[newLength];
        System.arraycopy(src, 0, newSrc, 0, src.length);
        for (int i = src.length; i < newLength; ++i) {
            newSrc[i] = fillWith;
        }
        return newSrc;
    }

    public static byte[] filledByteArray(int length, byte fillWith) {
        byte[] ba = new byte[length];
        for (int i = 0; i < length; ++i) {
            ba[i] = fillWith;
        }
        return ba;
    }

    public static Calendar getUTCnow() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public static Calendar getUTCtimestamp(long millis) {
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static Calendar getCalendar(int year, int month, int day) {
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static byte[] xor(byte[] a, byte[] b) {
        if (a == null || b == null) {
            throw new NullPointerException("arrays must not be null.");
        }
        if (a.length != b.length) {
            throw new IllegalArgumentException("arrays must be of the same length. (" + a.length + " != " + b.length + ")");
        }
        int len = a.length;
        byte[] buffer = new byte[a.length];
        for (int i = 0; i < len; ++i) {
            int v1 = a[i] & 0xFF;
            int v2 = b[i] & 0xFF;
            int xor = v1 ^ v2;
            buffer[i] = (byte)(xor & 0xFF);
        }
        return buffer;
    }

    public static byte[] invert(byte[] a) {
        if (a == null) {
            throw new NullPointerException("Array must not be null.");
        }
        return Util.xor(a, Util.filledByteArray(a.length, Util.u8ToByte(255)));
    }

    public static byte[] getRandom(int len) {
        byte[] random = new byte[len];
        try {
            SecureRandom srnd = HashTools.getSecureRandom();
            srnd.nextBytes(random);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return random;
    }

    public static byte[] getSHA1hash(byte[] input) throws Exception {
        byte[] result = null;
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(input);
        result = md.digest();
        return result;
    }

    @Deprecated
    public static String getSHA1hash(String str) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(str.getBytes());
        String result = Util.asHex(md.digest(), "");
        return result;
    }

    @Deprecated
    public static boolean equals(byte[] a, byte[] b) throws NullPointerException {
        if (a == null || b == null) {
            throw new NullPointerException("arrays must not be null.");
        }
        return Arrays.equals(a, b);
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    @Deprecated
    public static byte[] subArray(byte[] src, int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(src, offset, result, 0, length);
        return result;
    }

    public static String asHex(byte[] buf) {
        return Util.asHex(buf, " ");
    }

    public static String asHex(byte[] buf, String sep) {
        if (buf == null) {
            return "null";
        }
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
            if (i >= buf.length - 1 || sep == null) continue;
            strbuf.append(sep);
        }
        return strbuf.toString();
    }

    public static byte[] decodeHexstring(String s) {
        String s2 = s.replaceAll(" ", "").replaceFirst("0x", "");
        int bal = s2.length() / 2;
        byte[] ba = new byte[bal];
        for (int i = 0; i < bal; ++i) {
            String sub = s2.substring(i * 2, i * 2 + 2);
            ba[i] = Util.u8ToByte(Short.parseShort(sub, 16));
        }
        return ba;
    }

    public static int byteToU8(byte b) {
        return b & 0xFF;
    }

    public static byte u8ToByte(int u) {
        return (byte)u;
    }

    public static byte[] createZeroTerminatedString(String s) {
        return Util.createZeroTerminatedString(s, CHARSET_ASCII);
    }

    public static byte[] createZeroTerminatedString(String s, String charset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(s == null ? 0 : s.length() + 1);
        try {
            if (s != null) {
                baos.write(s.getBytes(charset));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        baos.write(0);
        return baos.toByteArray();
    }

    public static String parseZeroTerminatedString(byte[] ba) {
        return Util.parseZeroTerminatedString(ba, CHARSET_ASCII);
    }

    public static String parseZeroTerminatedString(byte[] ba, String charset) {
        String s = null;
        try {
            if (ba != null && ba.length > 1) {
                int zi;
                for (zi = 0; zi < ba.length && ba[zi] != 0; ++zi) {
                }
                s = new String(ba, 0, zi, charset);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s;
    }

    public static OperatingSystem getOperatingSystem() {
        if (operating_system == OperatingSystem.UNKOWN) {
            String osName = System.getProperty("os.name");
            operating_system = osName.toLowerCase().contains("window") ? OperatingSystem.WINDOWS : OperatingSystem.UNIX;
        }
        return operating_system;
    }

    public static boolean inWindows() {
        return Util.getOperatingSystem() == OperatingSystem.UNKOWN;
    }

    public static byte[] asBCD16(int pin) {
        byte[] ba = new byte[2];
        int bcd = 0;
        bcd |= pin % 10;
        bcd |= (pin /= 10) % 10 << 4;
        bcd |= (pin /= 10) % 10 << 8;
        ba[0] = (byte)(((bcd |= (pin /= 10) % 10 << 12) & 0xFF00) >> 8);
        ba[1] = (byte)(bcd & 0xFF);
        return ba;
    }

    public static int decodeBCD(byte[] ba) {
        int ret = 0;
        for (int i = 0; i < ba.length; ++i) {
            ret *= 100;
            ret += ((ba[i] & 0xF0) >> 4) * 10 + (ba[i] & 0xF);
        }
        return ret;
    }

    public static int decimalLength(long v) {
        int highBit = 64 - Long.numberOfLeadingZeros(v);
        int guess = DECIMAL_DIGITS_GUESS[highBit];
        return v >= TEN_TO_THE_LONGS[guess] ? guess + 1 : guess;
    }

    public static int decimalLength(int v) {
        int highBit = 32 - Integer.numberOfLeadingZeros(v);
        int guess = DECIMAL_DIGITS_GUESS[highBit];
        return v >= TEN_TO_THE_INTS[guess] ? guess + 1 : guess;
    }

    public static enum OperatingSystem {
        UNKOWN,
        WINDOWS,
        UNIX;

    }
}

