/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.lang;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class MappedList<P, T>
extends AbstractList<T> {
    private List<P> underlying;
    private Function<P, T> mapper;

    public MappedList(List<P> underlying, Function<P, T> mapper) {
        Objects.requireNonNull(underlying);
        Objects.requireNonNull(mapper);
        this.underlying = underlying;
        this.mapper = mapper;
    }

    public static <P, T> MappedList<P, T> newInstance(List<P> underlying, Function<P, T> mapper) {
        return new MappedList<P, T>(underlying, mapper);
    }

    @Override
    public T get(int i) {
        return this.mapper.apply(this.underlying.get(i));
    }

    @Override
    public int size() {
        return this.underlying.size();
    }
}

