/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    private IOUtil() {
    }

    public static byte readByte(InputStream is) throws IOException {
        int b = is.read();
        if (b == -1) {
            throw new EOFException("got an EOF");
        }
        return (byte)(b & 0xFF);
    }

    public static byte[] readZeroTerminatedString(InputStream is, int maxLength) throws IOException {
        byte val;
        int i = -1;
        byte[] temp = new byte[maxLength];
        do {
            temp[++i] = val = IOUtil.readByte(is);
        } while (val != 0 && i < maxLength);
        byte[] result = new byte[i + 1];
        System.arraycopy(temp, 0, result, 0, result.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteArrayFromFile(File baFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(baFile);){
            long ll = baFile.length();
            if (ll > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("File [" + String.valueOf(baFile) + "] is too large for a byte array.");
            }
            int len = (int)ll;
            byte[] ba = new byte[len];
            fis.read(ba, 0, len);
            byte[] byArray = ba;
            return byArray;
        }
    }

    public static void writeToFile(String baFileName, byte[] ba) throws IOException {
        IOUtil.writeToFile(new File(baFileName), ba);
    }

    public static void writeToFile(File baFile, byte[] ba) throws IOException {
        FileOutputStream fos = new FileOutputStream(baFile);
        fos.write(ba);
        fos.close();
    }

    public static byte[] readByteArrayFromFile(String baFileName) throws IOException {
        return IOUtil.readByteArrayFromFile(new File(baFileName));
    }

    public static void copyStreams(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] buf = new byte[4096];
        while ((n = is.read(buf)) > 0) {
            os.write(buf, 0, n);
        }
        os.flush();
    }

    public static String getFileExtension(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        return fileName.substring(pos + 1);
    }

    public static String getFileBaseName(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos < 0) {
            return fileName;
        }
        return fileName.substring(0, pos);
    }
}

