/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.formula.ast;

import org.clazzes.util.formula.FormulaHelper;
import org.clazzes.util.formula.SymbolValues;
import org.clazzes.util.formula.ast.FormulaNode;
import org.clazzes.util.formula.ast.FormulaNodeVisitor;
import org.clazzes.util.formula.ast.UnaryOpFormulaNode;

public class FunctionFormulaNode
extends UnaryOpFormulaNode {
    private static final long serialVersionUID = -2356820985554504221L;
    final String f;

    public FunctionFormulaNode(String f, FormulaNode rhs) {
        super(rhs);
        this.f = f;
    }

    @Override
    public String getOperator() {
        return this.f;
    }

    @Override
    public int getPrecedence() {
        return 10;
    }

    @Override
    public double evaluate(SymbolValues symbols) {
        return FormulaHelper.callBuiltin(this.f, this.getRhs().evaluate(symbols));
    }

    public String toString() {
        return "[" + this.f + "," + String.valueOf(this.getRhs()) + "]";
    }

    @Override
    public void accept(FormulaNodeVisitor visitor) {
        visitor.visit(this);
    }
}

