/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.datetime;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.TimeZone;
import org.clazzes.util.datetime.UtcTimestamp;

public class ISO8601Format
extends Format {
    private static final long serialVersionUID = 6403675010685159895L;
    public static int DATE_FORMAT = 1;
    public static int DATETIME_FORMAT = 2;
    public static int MILLISECOND_FORMAT = 3;
    public static int DATETIME_FORMAT_NO_TZ = 4;
    public static int MILLISECOND_FORMAT_NO_TZ = 5;
    private int format;
    private TimeZone timeZone;

    public ISO8601Format(int format) {
        this.format = format;
        this.timeZone = TimeZone.getTimeZone("UTC");
    }

    public ISO8601Format(int format, TimeZone timeZone) {
        this.format = format;
        this.timeZone = timeZone;
    }

    @Override
    public StringBuffer format(Object o, StringBuffer buf, FieldPosition pos) {
        if (o instanceof UtcTimestamp) {
            return buf.append(((UtcTimestamp)o).toString(this.format));
        }
        Calendar c = (Calendar)o;
        if (this.format == DATE_FORMAT) {
            buf.append(String.format("%04d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5)));
        } else if (this.format == DATETIME_FORMAT) {
            int off = c.get(15) + c.get(16);
            if (off == 0) {
                buf.append(String.format("%04d-%02d-%02dT%02d:%02d:%02dZ", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13)));
            } else if (off > 0) {
                buf.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d+%02d:%02d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), off / 3600000, off / 60000 % 60));
            } else {
                buf.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d-%02d:%02d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), off / -3600000, off / -60000 % 60));
            }
        } else if (this.format == DATETIME_FORMAT_NO_TZ) {
            buf.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13)));
        } else if (this.format == MILLISECOND_FORMAT_NO_TZ) {
            buf.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14)));
        } else {
            int off = c.get(15) + c.get(16);
            if (off == 0) {
                buf.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14)));
            } else if (off > 0) {
                buf.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d+%02d:%02d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14), off / 3600000, off / 60000 % 60));
            } else {
                buf.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d-%02d:%02d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14), off / -3600000, off / -60000 % 60));
            }
        }
        return buf;
    }

    private static int extractInt(String str, ParsePosition pos, int nDigit) {
        int iDigit;
        int ret = 0;
        int idx = pos.getIndex();
        for (iDigit = 0; iDigit < nDigit && Character.isDigit(str.charAt(idx)); ++iDigit) {
            ret = 10 * ret + Character.digit(str.charAt(idx), 10);
            ++idx;
        }
        if (iDigit < nDigit) {
            pos.setErrorIndex(idx);
            return -1;
        }
        pos.setIndex(idx);
        return ret;
    }

    @Override
    @Deprecated
    public Object parseObject(String str, ParsePosition pos) {
        int tz_off;
        int millis;
        int oidx = pos.getIndex();
        int year = ISO8601Format.extractInt(str, pos, 4);
        if (year < 0) {
            pos.setIndex(oidx);
            return null;
        }
        if (str.charAt(pos.getIndex()) != '-') {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(oidx);
            return null;
        }
        pos.setIndex(pos.getIndex() + 1);
        int month = ISO8601Format.extractInt(str, pos, 2);
        if (month < 0) {
            pos.setIndex(oidx);
            return null;
        }
        if (str.charAt(pos.getIndex()) != '-') {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(oidx);
            return null;
        }
        pos.setIndex(pos.getIndex() + 1);
        int day = ISO8601Format.extractInt(str, pos, 2);
        if (day < 0) {
            pos.setIndex(oidx);
            return null;
        }
        Calendar c = Calendar.getInstance(this.timeZone);
        c.set(year, month - 1, day);
        if (pos.getIndex() >= str.length() || str.charAt(pos.getIndex()) != 'T') {
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return c;
        }
        pos.setIndex(pos.getIndex() + 1);
        int hour = ISO8601Format.extractInt(str, pos, 2);
        if (hour < 0) {
            pos.setIndex(oidx);
            return null;
        }
        if (str.charAt(pos.getIndex()) != ':') {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(oidx);
            return null;
        }
        pos.setIndex(pos.getIndex() + 1);
        int minute = ISO8601Format.extractInt(str, pos, 2);
        if (minute < 0) {
            pos.setIndex(oidx);
            return null;
        }
        if (str.charAt(pos.getIndex()) != ':') {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(oidx);
            return null;
        }
        pos.setIndex(pos.getIndex() + 1);
        int second = ISO8601Format.extractInt(str, pos, 2);
        if (second < 0) {
            pos.setIndex(oidx);
            return null;
        }
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        if (pos.getIndex() >= str.length()) {
            return c;
        }
        if (str.charAt(pos.getIndex()) == '.') {
            pos.setIndex(pos.getIndex() + 1);
            millis = ISO8601Format.extractInt(str, pos, 3);
            if (millis < 0) {
                pos.setIndex(oidx);
                return null;
            }
        } else {
            millis = 0;
        }
        c.set(14, millis);
        if (pos.getIndex() >= str.length()) {
            return c;
        }
        if (str.charAt(pos.getIndex()) == 'Z') {
            pos.setIndex(pos.getIndex() + 1);
            tz_off = 0;
        } else {
            int sign = 0;
            switch (str.charAt(pos.getIndex())) {
                case '+': {
                    sign = 1;
                    break;
                }
                case '-': {
                    sign = -1;
                    break;
                }
                default: {
                    return c;
                }
            }
            pos.setIndex(pos.getIndex() + 1);
            int tz_hour = ISO8601Format.extractInt(str, pos, 2);
            if (tz_hour < 0) {
                pos.setIndex(oidx);
                return null;
            }
            if (str.charAt(pos.getIndex()) == ':') {
                pos.setIndex(pos.getIndex() + 1);
            }
            int tz_minute = ISO8601Format.extractInt(str, pos, 2);
            if (tz_hour < 0) {
                pos.setIndex(oidx);
                return null;
            }
            tz_off = sign * (tz_hour * 3600000 + tz_minute * 60000);
        }
        c.set(15, tz_off - c.get(16));
        assert (c.get(15) + c.get(16) == tz_off);
        return c;
    }
}

