/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 10.12.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.xml;

import java.io.OutputStream;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.ContentHandler;

/**
 * This class retrieves an XML serializer and compensates for the lack
 * of an XMLSerializerFactory in JAXP.
 * 
 * @author wglas
 */
public abstract class XMLSerializerHelper {
    
    static private final SAXTransformerFactory transformerFactory =
        (SAXTransformerFactory) TransformerFactory.newInstance();
    
/*
    Well, all this code is nice, but XMLSeraililzer seems to ignore ignorableWhitespace,
    so we stick to the method by instantiating a serializer through a TransformerFactory.
 
    private static Class<?> serializerClass;
    private static Method setOutputByteStreamMethod;
    
    private static final String classNamesToConsider[] =
    {
        "org.apache.xml.serialize.XMLSerializer",
        "com.sun.org.apache.xml.internal.serialize.XMLSerializer"
    };
    
    static {
        
        for (int i=0; serializerClass == null && i<classNamesToConsider.length; ++i)
        {
            try {
            
                serializerClass = Class.forName(classNamesToConsider[i]);
                if (!ContentHandler.class.isAssignableFrom(serializerClass))
                    serializerClass = null;
                
                try {
                    setOutputByteStreamMethod = serializerClass.getMethod("setOutputByteStream",OutputStream.class);
                } catch (SecurityException e) {
                    serializerClass = null;
                } catch (NoSuchMethodException e) {
                    serializerClass = null;
                }
               
            } catch (ClassNotFoundException e) {}
        }
        
        if (serializerClass == null)
            throw new MissingResourceException("Cannot find an XMLSerializer",classNamesToConsider[0],"ContentHandler");
    }
  */  
    /**
     * @return A ContentHandler, which write to an XML file.
     */
    public static ContentHandler newSerializer(OutputStream os)
    {
        /*
        try {
            ContentHandler ret = (ContentHandler) serializerClass.newInstance();
            
            setOutputByteStreamMethod.invoke(ret,os);
            
            return ret;
            
        } catch (InstantiationException e) {
            throw new MissingResourceException("Cannot instantiate an XMLSerializer",serializerClass.getName(),"ContentHandler");
        } catch (IllegalAccessException e) {
            throw new MissingResourceException("Instantiation of an XMLSerializer is forbidden",serializerClass.getName(),"ContentHandler");
        } catch (IllegalArgumentException e) {
            throw new MissingResourceException("Invalid argument initializing an XMLSerializer",serializerClass.getName(),"ContentHandler");
        } catch (InvocationTargetException e) {
            throw new MissingResourceException("Upstream exception initializing an XMLSerializer",serializerClass.getName(),"ContentHandler");
        }
        */
        
        TransformerHandler ret;
        try {
            ret = transformerFactory.newTransformerHandler();
        } catch (TransformerConfigurationException e) {
            throw new RuntimeException("Error instantiating SAX transformer.",e);
        }
        
        ret.setResult(new StreamResult(os));
        return ret;
    }
}
