/***********************************************************
 * $Id$
 *
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 07.12.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.util.xml;

import java.util.HashMap;
import java.util.Map;

import javax.xml.XMLConstants;

import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

/**
 * This class resolves module-resident schema descriptions.
 *
 * @author wglas
 */
public class ModuleLSResourceResolver implements LSResourceResolver {

    private final Module module;
    private final Map<String,String> xsdResources;

    /**
     * Construct a module resource resoulver.
     *
     * @param module The module to load resources from.
     */
    public ModuleLSResourceResolver(Module module) {
        this.xsdResources = new HashMap<String, String>();
        this.module = module;
    }

    /**
     * Add a classpath-resident schema description to this resource resolver.
     *
     * @param nsURI
     * @param resourcePath
     */
    public void addXSDResource(String nsURI, String resourcePath) {

        this.xsdResources.put(nsURI,resourcePath);
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSResourceResolver#resolveResource(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    public LSInput resolveResource(String type, String namespaceURI,
            String publicId, String systemId, String baseURI) {

        if (XMLConstants.W3C_XML_SCHEMA_NS_URI.equals(type))
        {
            String resourcePath = this.xsdResources.get(namespaceURI);

            if (resourcePath != null)
                return new ModuleLSInput(this.module,resourcePath,publicId,systemId,baseURI);
        }

        return null;
    }

    public Module getModule() {
        return this.module;
    }

}
