/***********************************************************
 * $Id$
 *
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 2007-12-07
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.util.xml;

import java.io.InputStream;
import java.io.Reader;

import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

/**
 * This implementation of LSInput represents an XML input source
 * for classpath-resident schema or DTD descriptions, which are emitted
 * by a handcrafted instance of {@link LSResourceResolver}.
 *
 * @author wglas
 */
@Deprecated
public class ClasspathLSInput implements LSInput {

    private final String resourcePath;
    private final ClassLoader classLoader;
    private String baseURI;
    private String publicId;
    private String systemId;
    private boolean certifiedText;

    /**
     * Construct a classpath-resident LSInput instance.
     *
     * @param classLoader The class loader from which to retrieve the resource stream.
     * @param resourcePath The path, where the resource is located. Will be passed
     *                     to {@link ClassLoader#getResourceAsStream(String)}.
     * @param publicId The XML public ID of the resource.
     * @param systemId The XML system ID of the resource.
     * @param baseURI The XML base URI of the resource.
     * @param certifiedText The XML-1.1 flag, which marks the resource as certified.
     */
    public ClasspathLSInput(ClassLoader classLoader, String resourcePath,
            String publicId,
            String systemId,
            String baseURI,
            boolean certifiedText) {

        this.resourcePath = resourcePath;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.certifiedText = certifiedText;
        this.classLoader = classLoader;
    }

    /**
     * Construct a classpath-resident LSInput instance.
     *
     * @param classLoader The class loader from which to retrieve the resource stream.
     * @param resourcePath The path, where the resource is located. Will be passed
     *                     to {@link ClassLoader#getResourceAsStream(String)}.
     * @param publicId The XML public ID of the resource.
     * @param systemId The XML system ID of the resource.
     * @param baseURI The XML base URI of the resource.
     */
    public ClasspathLSInput(ClassLoader classLoader, String resourcePath,
            String publicId,
            String systemId,
            String baseURI) {

        this.resourcePath = resourcePath;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.certifiedText = true;
        this.classLoader = classLoader;
    }

    /**
     * Construct a classpath-resident LSInput instance. This constructor loads from
     * the class loader of the {@link ClasspathLSInput} class itself.
     *
     * @param resourcePath The path, where the resource is located. Will be passed
     *                     to {@link ClassLoader#getResourceAsStream(String)}.
     * @param publicId The XML public ID of the resource.
     * @param systemId The XML system ID of the resource.
     * @param baseURI The XML base URI of the resource.
     * @param certifiedText The XML-1.1 flag, which marks the resource as certified.
     */
    public ClasspathLSInput(String resourcePath,
            String publicId,
            String systemId,
            String baseURI,
            boolean certifiedText) {

        this.resourcePath = resourcePath;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.certifiedText = certifiedText;
        this.classLoader = ClasspathLSInput.class.getClassLoader();
    }

    /**
     * Construct a classpath-resident LSInput instance. This constructor loads from
     * the class loader of the {@link ClasspathLSInput} class itself.
     *
     * @param resourcePath The path, where the resource is located. Will be passed
     *                     to {@link ClassLoader#getResourceAsStream(String)}.
     * @param publicId The XML public ID of the resource.
     * @param systemId The XML system ID of the resource.
     * @param baseURI The XML base URI of the resource.
     */
    public ClasspathLSInput(String resourcePath,
            String publicId,
            String systemId,
            String baseURI) {

        this.resourcePath = resourcePath;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.certifiedText = true;
        this.classLoader = ClasspathLSInput.class.getClassLoader();
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#getBaseURI()
     */
    public String getBaseURI() {
        return this.baseURI;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#getByteStream()
     */
    public InputStream getByteStream() {
        InputStream is =
            this.classLoader.getResourceAsStream(this.resourcePath);

        return is;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#getCertifiedText()
     */
    public boolean getCertifiedText() {
        return this.certifiedText;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#getCharacterStream()
     */
    public Reader getCharacterStream() {
        return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#getEncoding()
     */
    public String getEncoding() {
        return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#getPublicId()
     */
    public String getPublicId() {
        return this.publicId;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#getStringData()
     */
    public String getStringData() {
        return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#getSystemId()
     */
    public String getSystemId() {
        return this.systemId;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#setBaseURI(java.lang.String)
     */
    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#setByteStream(java.io.InputStream)
     */
    public void setByteStream(InputStream byteStream) {
        throw new UnsupportedOperationException();
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#setCertifiedText(boolean)
     */
    public void setCertifiedText(boolean certifiedText) {
        this.certifiedText = certifiedText;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#setCharacterStream(java.io.Reader)
     */
    public void setCharacterStream(Reader characterStream) {
        throw new UnsupportedOperationException();
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#setEncoding(java.lang.String)
     */
    public void setEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#setPublicId(java.lang.String)
     */
    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#setStringData(java.lang.String)
     */
    public void setStringData(String stringData) {
        throw new UnsupportedOperationException();
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.ls.LSInput#setSystemId(java.lang.String)
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }


}
