/**
 * $Id: TokenOtpChecker.java 401 2017-10-10 12:43:57Z msrvmgr $
 *
 * (C) Copyright 2017 ITEG IT-Engineers GmbH
 */

package org.clazzes.util.sec;

import java.io.IOException;

/**
 * Interface for services to check token OTPs, e.g. generated by a yubikey.
 */
public interface TokenOtpChecker {

    /**
     * Check the given token OTP against a source of random numbers
     * and a list of known token IDs.
     *
     * @param otp A token-generated OTP.
     * @param knownIds A list of known token IDs with an implementation-specific length
     *                 (12 characters for yubikeys).
     * @return Whether the given OTP was checked to be generated of one of the token IDs from
     *         the given list.
     */
    public boolean checkOTP(String otp, String[] knownIds) throws IOException;
}
