/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 2006-03-13
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sec;

/**
 * The Plain text (pseudo) hasher
 */
public class PlainPasswordHasher implements PasswordHasher
{

	protected final String algo_prefix;

	public PlainPasswordHasher()
	{
		super();
		this.algo_prefix = "{" + getAlgorithmName() + "}";
	}

	/* (non-Javadoc)
	 * @see org.clazzes.util.sec.PasswordHasher#hashPassword(java.lang.String)
	 */
	public String hashPassword(String cleartext)
	{
		return hashPassword(cleartext, HashTools.randomSalt());
	}

	/* (non-Javadoc)
	 * @see org.clazzes.util.sec.PasswordHasher#hashPassword(java.lang.String, java.lang.String)
	 */
	public String hashPassword(String cleartext, String salt)
	{
		return this.algo_prefix + cleartext;
	}

	/* (non-Javadoc)
	 * @see org.clazzes.util.sec.PasswordHasher#checkPassword(java.lang.String, java.lang.String)
	 */
	public boolean checkPassword(String cleartext, String hashed)
	{
		return cleartext.equals(stripAlgorithmKey(hashed));
	}

	/* (non-Javadoc)
	 * @see org.clazzes.util.sec.PasswordHasher#getAlgorithmName()
	 */
	public String getAlgorithmName()
	{
		return "PLAIN";
	}

	public String getAlgorithmPrefix()
	{
		return this.algo_prefix;
	}

	/**
	 * @param from_password
	 * @return The given hashed password without eventual leading "{algo_key}"
	 */
	protected String stripAlgorithmKey(String from_password)
	{
		if (from_password == null)
			return null;
		if (from_password.startsWith(this.algo_prefix))
		{
			String s = from_password.substring(this.algo_prefix.length());
			return s;
		}
		return from_password;
	}

	/**
	 * @param to_password
	 * @return The given hashed password with an eventual missing "{algo_key}"
	 *         prefix
	 */
	protected String prependAlgorithmKey(String to_password)
	{
		if (to_password == null)
			return null;
		if (to_password.startsWith(this.algo_prefix))
			return to_password;
		return this.algo_prefix + to_password;

	}

    /* (non-Javadoc)
     * @see org.clazzes.util.sec.PasswordHasher#getDefaultSaltLength()
     */
    public int getSaltLength() {
        return 0;
    }

}
