/***********************************************************
 * $Id$
 * 
 * org.clazzes Utils
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sec;

import java.util.Collection;

/**
 * @author lech
 *
 * Classes implementing this interface provide password hasher instances.
 */
public interface PasswordHasherFactory {

    /**
     * Returns an instance of a password hasher for the given algorithm name, or null if none could be found.
     * @param algo_name Name of hasher algorithm a PasswordHasher is wished for.
     * @return a passwordhasher, if possible, null otherwise.
     */
    public abstract PasswordHasher getPasswordHasher(String algo_name);

    /**
     * @return a Collection of password hashers known to this factory.
     */
    public abstract Collection<PasswordHasher> getKnownPasswordHashers();

}
