/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 2006-03-13
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sec;

/**
 * The password hasher interface, to allow maximum flexibility
 */
public interface PasswordHasher
{

	/**
     * Hashes the given password using a random salt.
	 * @param cleartext Password to hash.
	 * @return the hashed i.e. encrypted password. includes the algorithm prefix.
	 */
	public String hashPassword(String cleartext);

	/**
     * Hashes the given password using the given salt.
     * @param cleartext Password to hash.
     * @param salt the salt to use.
     * @return the hashed i.e. encrypted password. includes the algorithm prefix.
	 */
	public String hashPassword(String cleartext, String salt);

	/**
     * Checks if the given cleartext password conforms to the given hashed representation.
	 * @param cleartext cleartext password to check.
	 * @param hashed hashed correct password to check against. may include the algorithm prefix.
	 * @return true if the password seems correct.
	 */
	public boolean checkPassword(String cleartext, String hashed);

	/**
	 * @return the name (key) of the algorithm implemented by this hasher, as used in the algorithm prefix of hashed passwords.
	 */
	public String getAlgorithmName();
    
    
    /**
     * @return the (default resp. relevant) salt length for the hash algorithm
     */
    public int getSaltLength();

}
